// set registers width
#if defined(__AVR__)
  #define WIDTH_REG   uint8_t
#elif defined(__arm__)
  #define WIDTH_REG   uint32_t
#endif

// for debug
#define PIN_SEND      10
#define PIN_RECEIVE   11


// custom routine attached to Serial send interrupt (called after complete buffer sent)
void ISR_send(void) {
  digitalWrite(PIN_SEND, !digitalRead(PIN_SEND));
  Serial.print("send ISR "); Serial.println(millis());
}


// custom routine attached to Serial receive interrupt (called after each byte)
void ISR_receive(uint8_t data, WIDTH_REG status) {
  digitalWrite(PIN_RECEIVE, !digitalRead(PIN_RECEIVE));
  Serial.print("receive ISR: 0x"); Serial.print(data, HEX); Serial.print(" "); Serial.println(millis());
}


// setup board
void setup() {

  // for debug
  Serial.begin(115200); while(!Serial);
  pinMode(PIN_SEND,OUTPUT);
  pinMode(PIN_RECEIVE,OUTPUT);
  
  // attach custom routines to TxD and UDRE interrupts
  Serial1.begin(19200); while(!Serial1);
  Serial1.attachInterrupt_Send(ISR_send);
  Serial1.attachInterrupt_Receive(ISR_receive);

}


// call periodically
void loop() {
  static uint16_t   count = 0;
  static uint32_t   lastTime=0;
  uint8_t           buf[5] = {1,2,3,4,5};

  // send some byte -> trigger Tx/Rx interrupts
  if (millis() - lastTime > 1000) {
    lastTime = millis();
    Serial1.write(buf,2);

    // count loop cycles
    count++;
  
    /// detach ISR_send
    if (count == 5) {
      Serial.println("Serial1.detachInterrupt_Send()");
      Serial1.detachInterrupt_Send();
    }
  
    // detach ISR_receive
    if (count == 10) {
      Serial.println("Serial1.detachInterrupt_Receive()");
      Serial1.detachInterrupt_Receive();
    }
    
    // re-attach ISR_send
    if (count == 15) {
      Serial.println("Serial1.attachInterrupt_Send()");
      Serial1.attachInterrupt_Send(ISR_send);
    }
  
    // re-attach ISR_receive
    if (count == 20) {
      Serial.println("Serial1.attachInterrupt_Receive()");
      Serial1.attachInterrupt_Receive(ISR_receive);
    }
    
  } // period expired
  
}
