/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.monitoring.mautil.rest;

import com.ibm.juno.client.SSLOpts;
import com.ibm.juno.core.ini.ConfigFile;
import com.ibm.juno.core.parser.ParseException;
import com.ibm.team.serviceability.monitoring.mautil.DataMapper;
import com.ibm.team.serviceability.monitoring.mautil.DataMonitorService;
import com.ibm.team.serviceability.monitoring.mautil.rest.RestDataReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RestDataMonitorService
extends DataMonitorService {
    private static final Logger logger = Logger.getLogger(RestDataMonitorService.class.getName());
    protected static final String CF_RESTREADER_SUFFIX = "RESTReader";
    protected RestDataReader restreader;
    public static final String HTTPCONST = "http";
    public static final String HTTPSCONST = "https";
    private boolean secured = false;
    protected String section;
    protected String apiTargetRoot;

    public RestDataMonitorService(String section, ConfigFile cf) {
        super(section, cf);
        this.section = section;
        this.cf = cf;
        String hostname = cf.getString(String.valueOf(section) + CF_RESTREADER_SUFFIX + "/hostname", "localhost");
        int port = cf.getInt(String.valueOf(section) + CF_RESTREADER_SUFFIX + "/port", 80);
        String protocol = cf.getString(String.valueOf(section) + CF_RESTREADER_SUFFIX + "/protocol", HTTPCONST);
        if (HTTPSCONST.equalsIgnoreCase(protocol)) {
            this.secured = true;
        }
        String adminUser = cf.getString(String.valueOf(section) + CF_RESTREADER_SUFFIX + "/adminUser", "wasadmin");
        String adminPassword = cf.getString(String.valueOf(section) + CF_RESTREADER_SUFFIX + "/adminPassword", "wasadmin");
        String truststore = cf.getString(String.valueOf(section) + CF_RESTREADER_SUFFIX + "/truststore", "resources/security/ibm-team-ssl.keystore");
        String truststoreType = cf.getString(String.valueOf(section) + CF_RESTREADER_SUFFIX + "/truststoreType", "JCEKS");
        String truststorePassword = cf.getString(String.valueOf(section) + CF_RESTREADER_SUFFIX + "/truststorePassword", "ibm-team");
        SSLOpts sslOptions = null;
        try {
            sslOptions = (SSLOpts)cf.getObject(SSLOpts.class, String.valueOf(section) + CF_RESTREADER_SUFFIX + "/ssl");
        }
        catch (ParseException e) {
            logger.log(Level.SEVERE, "Error loading SSL configuration");
        }
        this.apiTargetRoot = cf.getString(String.valueOf(section) + CF_RESTREADER_SUFFIX + "/apiTargetRoot", "");
        this.dataurl = String.valueOf(protocol) + "://" + hostname + ":" + port;
        try {
            this.restreader = this.secured ? new RestDataReader(protocol, hostname, port, adminUser, adminPassword, truststore, truststoreType, truststorePassword, sslOptions) : new RestDataReader(protocol, hostname, port);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error creating new RestDataReader", t);
        }
        this.mapper = new DataMapper();
    }
}

