/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.monitoring.mautil.mqtt;

import com.ibm.juno.core.ObjectMap;
import com.ibm.juno.core.json.JsonSerializer;
import com.ibm.juno.core.serializer.SerializeException;
import com.ibm.team.serviceability.monitoring.mautil.DataSender;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttDataPublisher
extends DataSender {
    private static final Logger logger = Logger.getLogger(MqttDataPublisher.class.getName());
    private final String clientId;
    private final String broker;
    private String topic = "com.ibm.team.serviceability.monitoring";
    private int qos = 0;
    private MemoryPersistence persistence;
    private MqttClient mqttclient;
    public static final int DEFAULTQOS = 0;
    public static final String DEFAULTTOPIC = "com.ibm.team.serviceability.monitoring";
    public static final long DEFAULT_TIMEOUT = 30000L;
    private boolean existingBroadcastError = false;

    public MqttDataPublisher(String broker, String clientId) {
        logger.log(Level.INFO, "Broker: {0}", broker);
        logger.log(Level.INFO, "ClientID: {0}", clientId);
        this.broker = broker;
        this.clientId = clientId;
        this.restartMqttClient();
    }

    @Override
    public boolean sendJSONMessage(ObjectMap json) {
        return this.sendJSONMessage(this.topic, json);
    }

    @Override
    public boolean sendMessage(String message) {
        return this.sendMessage(this.topic, message);
    }

    public boolean sendJSONMessage(String topic, ObjectMap json) {
        if (json != null) {
            try {
                String message = JsonSerializer.DEFAULT.serialize((Object)json);
                return this.sendMessage(topic, message);
            }
            catch (SerializeException e) {
                logger.log(Level.SEVERE, "Error serializing message", e);
                return false;
            }
        }
        return false;
    }

    public boolean sendMessage(String topic, String message) {
        return this.broadcastMqttMessage(topic, message, this.qos);
    }

    private static final MqttClient createMqttClient(String broker, String clientId, MemoryPersistence persistence) {
        try {
            return new MqttClient(broker, clientId, (MqttClientPersistence)persistence);
        }
        catch (MqttException me) {
            MqttDataPublisher.logMqttException(me);
            return null;
        }
    }

    private static final void deleteMqttClient(MqttClient client) {
        try {
            if (client != null) {
                if (client.isConnected()) {
                    client.disconnectForcibly();
                }
                client.close();
            }
        }
        catch (MqttException me) {
            MqttDataPublisher.logMqttException(me);
        }
        client = null;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String newTopic) {
        this.changeTopic(newTopic, false);
    }

    public void setTimeToWait(long timeToWaitInMillis) {
        if (this.mqttclient != null) {
            this.mqttclient.setTimeToWait(timeToWaitInMillis);
        }
    }

    private synchronized void changeTopic(String newTopic, boolean changeClient) {
        if (newTopic != null) {
            this.topic = newTopic;
            if (changeClient) {
                this.restartMqttClient();
            }
        }
    }

    private void restartMqttClient() {
        MqttDataPublisher.deleteMqttClient(this.mqttclient);
        this.mqttclient = MqttDataPublisher.createMqttClient(this.broker, this.clientId, this.persistence);
        this.mqttclient.setTimeToWait(30000L);
    }

    public final synchronized boolean broadcastMqttMessage(String topic, String content, int nQos) {
        logger.log(Level.FINE, "MQTT send started on thread {0}", Thread.currentThread().getName());
        if (this.mqttclient != null) {
            try {
                if (!this.mqttclient.isConnected()) {
                    logger.log(Level.FINE, "Connecting to broker: {0}", this.broker);
                    long t = System.currentTimeMillis();
                    MqttConnectOptions connOpts = new MqttConnectOptions();
                    connOpts.setCleanSession(true);
                    connOpts.setConnectionTimeout(15);
                    this.mqttclient.connect(connOpts);
                    t = System.currentTimeMillis() - t;
                    logger.log(Level.FINE, "Connected in {0} ms", t);
                }
                logger.log(Level.FINE, "message to publish: {0}", content);
                MqttMessage message = new MqttMessage(content.getBytes("UTF-8"));
                logger.log(Level.FINE, "QoS level: {0}", nQos);
                message.setQos(nQos);
                logger.log(Level.FINE, "Publishing message to topic: {0}", topic);
                long t = System.currentTimeMillis();
                this.mqttclient.publish(topic, message);
                this.existingBroadcastError = false;
                t = System.currentTimeMillis() - t;
                logger.log(Level.FINE, "Message published in {0} ms", t);
                return true;
            }
            catch (MqttException me) {
                if (!this.existingBroadcastError) {
                    this.existingBroadcastError = true;
                    MqttDataPublisher.logMqttException(me);
                } else {
                    logger.log(Level.FINE, "Error broadcasting message to MQTT", me);
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.SEVERE, "Unsupported encoding error occurred", e);
            }
        }
        return false;
    }

    public void setQOS(int qos) {
        this.qos = qos;
    }

    private static final void logMqttException(MqttException me) {
        logger.log(Level.SEVERE, "Logged Mqtt Exception", me);
        logger.log(Level.FINE, "reason code: {0}", me.getReasonCode());
        logger.log(Level.FINE, "message: {0}", me.getMessage());
        logger.log(Level.FINE, "localized message: {0}", me.getLocalizedMessage());
        logger.log(Level.FINE, "cause: {0}", me.getCause());
        logger.log(Level.FINE, "exception: {0}", me);
    }
}

