/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.monitoring.mautil.guards;

import com.ibm.juno.server.RestException;
import com.ibm.juno.server.RestGuard;
import com.ibm.juno.server.RestRequest;
import com.ibm.juno.server.RestResponse;
import com.ibm.team.integration.auth.sdk.internal.JsaPrincipal;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class JazzGroupGuard
extends RestGuard {
    public static final String JAZZ_ADMINS = "JazzAdmins";
    private String[] allowedGroups;
    private Logger LOG = Logger.getLogger(JazzGroupGuard.class.getName());

    public JazzGroupGuard(String[] allowedGroups) {
        if (allowedGroups == null) {
            throw new IllegalArgumentException("The guard must have an allowed group.");
        }
        this.allowedGroups = allowedGroups;
    }

    public boolean isRequestAllowed(RestRequest req) {
        Principal principal = req.getUserPrincipal();
        if (principal == null) {
            return true;
        }
        if (!(principal instanceof JsaPrincipal)) {
            return true;
        }
        JsaPrincipal jp = (JsaPrincipal)principal;
        String[] stringArray = this.allowedGroups;
        int n = this.allowedGroups.length;
        int n2 = 0;
        while (n2 < n) {
            String g = stringArray[n2];
            if (jp.isUserInRole(g)) {
                return true;
            }
            ++n2;
        }
        String roles = jp.getRolesAsString(";");
        this.LOG.warning(MessageFormat.format("User {0} is part of the following roles(s): {1}\nThis resource requires the following roles: {2}", jp.getName().trim(), roles, this.getAllowedGroupsAsString()));
        if (roles.contains("=")) {
            this.LOG.warning("The user registry settings may be set incorrectly.  Please refer to the cfg file UserRegistry section.");
        }
        return false;
    }

    public boolean guard(RestRequest req, RestResponse res) throws RestException {
        if (!this.isRequestAllowed(req)) {
            throw new RestException(403, MessageFormat.format("User {0} does not have access to this resource.", req.getUserPrincipal() != null ? req.getUserPrincipal().getName().trim() : ""), new Object[0]);
        }
        return true;
    }

    public String getAllowedGroupsAsString() {
        StringBuffer buffer = new StringBuffer();
        int s = 0;
        while (s < this.allowedGroups.length) {
            buffer.append(this.allowedGroups[s]);
            if (s < this.allowedGroups.length - 1) {
                buffer.append(", ");
            }
            ++s;
        }
        return buffer.toString();
    }
}

