/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.deployment.api.utils;

import com.ibm.juno.client.RestClient;
import com.ibm.juno.core.ObjectMap;
import com.ibm.juno.core.json.JsonParser;
import com.ibm.juno.core.json.JsonSerializer;
import com.ibm.juno.core.parser.Parser;
import com.ibm.juno.core.serializer.Serializer;
import com.ibm.team.serviceability.deployment.api.managers.ConfigurationManager;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;

public class ProxyUtils {
    private static final String KUBERNETES_DASHBOARD_SUFFIX = "-kubedash";
    private static final String KUBERNETES_DASHBOARD_DOMAIN = "-kubedash.clmsvcs.ibmcloud.com";
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String PROXY_SERVICE_PASSWORD = "ec11ipse";
    private static final String PROXY_SERVICE_USER = "proxy";
    private static final String MINION_PORT_SUFFIX = ":9090";
    private static final String PROXY_PORT_SUFFIX = ":22000";

    public static String generateKubernetesDashboardUrl(String hubShortCode, String envCode, String envUuid, String opsProxyIp, String envProxyIp, String minionIp, Logger logger) {
        RestClient proxyRc;
        URL url;
        if (opsProxyIp == null) {
            logger.severe("KubeDashboard url creation problems. Platform tier Proxy IP is null.");
            return null;
        }
        if (envProxyIp == null) {
            logger.severe("KubeDashboard url creation problems. Environment tier Proxy IP is null.");
            return null;
        }
        String opsProxyServiceUrl = HTTP_PROTOCOL_PREFIX + opsProxyIp + PROXY_PORT_SUFFIX;
        ObjectMap json = new ObjectMap();
        json.append("instanceName", (Object)(String.valueOf(hubShortCode) + envCode + KUBERNETES_DASHBOARD_SUFFIX));
        try {
            url = new URL(opsProxyServiceUrl);
            proxyRc = new RestClient((Serializer)JsonSerializer.DEFAULT, (Parser)JsonParser.DEFAULT).setBasicAuth(url.getHost(), url.getPort(), PROXY_SERVICE_USER, PROXY_SERVICE_PASSWORD).setRootUrl(opsProxyServiceUrl).enableSSL(null).setPooled();
            proxyRc.doPost((Object)"/dns", (Object)json).run();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException e) {
            logger.severe("KubeDashboard url creation problems. Failed to create alias due to " + e);
            return null;
        }
        json = new ObjectMap();
        json.append("instanceFQName", (Object)(String.valueOf(hubShortCode) + envCode + KUBERNETES_DASHBOARD_DOMAIN));
        json.append("instanceUrl", (Object)(String.valueOf(envProxyIp) + ":" + ConfigurationManager.INSTANCE.getKubernetesProxyPort()));
        json.append("ssl", (Object)"true");
        try {
            url = new URL(opsProxyServiceUrl);
            proxyRc = new RestClient((Serializer)JsonSerializer.DEFAULT, (Parser)JsonParser.DEFAULT).setBasicAuth(url.getHost(), url.getPort(), PROXY_SERVICE_USER, PROXY_SERVICE_PASSWORD).setRootUrl(opsProxyServiceUrl).enableSSL(null).setPooled();
            proxyRc.doPost((Object)"/proxy/route", (Object)json).run();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException e) {
            logger.severe("KubeDashboard url creation problems. Failed to create route due to " + e);
            return null;
        }
        if (minionIp == null) {
            logger.severe("KubeDashboard url creation problems. Minion IP is null.");
            return null;
        }
        json = new ObjectMap();
        json.append("instanceFQName", (Object)(String.valueOf(hubShortCode) + envCode + KUBERNETES_DASHBOARD_DOMAIN));
        json.append("instanceUrl", (Object)(String.valueOf(minionIp) + MINION_PORT_SUFFIX));
        json.append("ssl", (Object)"false");
        try {
            String envProxyServiceUrl = HTTP_PROTOCOL_PREFIX + envProxyIp + PROXY_PORT_SUFFIX;
            URL url2 = new URL(envProxyServiceUrl);
            RestClient proxyRc2 = new RestClient((Serializer)JsonSerializer.DEFAULT, (Parser)JsonParser.DEFAULT).setBasicAuth(url2.getHost(), url2.getPort(), PROXY_SERVICE_USER, PROXY_SERVICE_PASSWORD).setRootUrl(envProxyServiceUrl).enableSSL(null).setPooled();
            proxyRc2.doPost((Object)"/proxy/route", (Object)json).run();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException e) {
            logger.severe("KubeDashboard url creation problems. Failed to create route due to " + e);
            return null;
        }
        return "https://" + hubShortCode + envCode + KUBERNETES_DASHBOARD_DOMAIN + ":" + ConfigurationManager.INSTANCE.getKubernetesProxyPort();
    }

    public static boolean deleteProxyRoute(String hubShortCode, String envCode, String opsProxyIp, Logger logger) {
        if (opsProxyIp == null) {
            logger.severe("KubeDashboard proxy route clean up problem. Platform tier Proxy IP is null.");
            return false;
        }
        String opsProxyServiceUrl = HTTP_PROTOCOL_PREFIX + opsProxyIp + PROXY_PORT_SUFFIX;
        try {
            URL url = new URL(opsProxyServiceUrl);
            RestClient proxyRc = new RestClient((Serializer)JsonSerializer.DEFAULT, (Parser)JsonParser.DEFAULT).setBasicAuth(url.getHost(), url.getPort(), PROXY_SERVICE_USER, PROXY_SERVICE_PASSWORD).setRootUrl(opsProxyServiceUrl).enableSSL(null).setPooled();
            String proxyRouteName = String.valueOf(hubShortCode) + envCode + KUBERNETES_DASHBOARD_SUFFIX + ConfigurationManager.INSTANCE.getKubernetesProxyPort();
            proxyRc.doDelete((Object)("/proxy/route/" + proxyRouteName)).run();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException e) {
            logger.severe("KubeDashboard proxy route clean up problem. Failed to create route due to " + e);
            return false;
        }
        return true;
    }
}

