/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.deployment.api.systems;

import com.ibm.juno.core.ObjectList;
import com.ibm.juno.core.ObjectMap;
import com.ibm.juno.core.parser.ParseException;
import com.ibm.juno.core.serializer.SerializeException;
import com.ibm.team.serviceability.cloudstack.client.CloudStackCommandManager;
import com.ibm.team.serviceability.cloudstack.client.CloudStackUtils;
import com.ibm.team.serviceability.cloudstack.client.command.CloudStackCommandException;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoKind;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoModel;
import com.ibm.team.serviceability.datamodel.deployment.vm.VirtualMachineModel;
import com.ibm.team.serviceability.datamodel.deployment.vm.VirtualMachineStatus;
import com.ibm.team.serviceability.datamodel.deployment.vm.VirtualMachineType;
import com.ibm.team.serviceability.datamodel.storage.StorageUtils;
import com.ibm.team.serviceability.deployment.api.Messages;
import com.ibm.team.serviceability.deployment.api.chef.ChefManager;
import com.ibm.team.serviceability.deployment.api.chef.Cookbook;
import com.ibm.team.serviceability.deployment.api.managers.ConfigurationManager;
import com.ibm.team.serviceability.deployment.api.managers.InfrastructureManager;
import com.ibm.team.serviceability.deployment.api.managers.ServiceManager;
import com.ibm.team.serviceability.deployment.api.managers.storage.ElasticManager;
import com.ibm.team.serviceability.deployment.api.managers.vmtopology.ServiceConfiguration;
import com.ibm.team.serviceability.deployment.api.services.ChefClientService;
import com.ibm.team.serviceability.deployment.api.services.IService;
import com.ibm.team.serviceability.deployment.api.services.ServiceException;
import com.ibm.team.serviceability.deployment.api.systems.DataCenter;
import com.ibm.team.serviceability.deployment.api.systems.Environment;
import com.ibm.team.serviceability.deployment.api.systems.IInfrastructureObject;
import com.ibm.team.serviceability.deployment.api.utils.CommandUtils;
import com.ibm.team.serviceability.deployment.api.utils.IActionToWait;
import com.ibm.team.serviceability.deployment.api.utils.ThreadUtils;
import com.ibm.team.serviceability.ssh.client.SSHCommandException;
import com.ibm.team.serviceability.ssh.client.SSHUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VirtualMachine
extends VirtualMachineModel
implements IInfrastructureObject,
Comparable<VirtualMachine> {
    private static final Logger logger = Logger.getLogger(VirtualMachine.class.getName());
    private String jobId = null;

    public VirtualMachine(String uuid, String name, VirtualMachineType type, String description, String ip, String publicIp, String user, String password, Boolean exists, Boolean isCloudStack, String hostname, String nodeName, String networkId, String machineId, Integer diskspace, Integer cpuCount, Integer ramSize, VirtualMachineStatus status, String environmentUuid, String datacenterUuid) {
        super(uuid, name, type, description, ip, publicIp, user, password, exists, isCloudStack, hostname, nodeName, networkId, machineId, diskspace, cpuCount, ramSize, status, environmentUuid, datacenterUuid);
    }

    public VirtualMachine(String uuid, String name, String ip, String publicIp, String user, String password, Boolean exists, Boolean isCloudStack, String hostname, String nodeName, String networkId, String machineId, Integer diskspace, Integer cpuCount, Integer ramSize, VirtualMachineStatus status, Environment parent, DataCenter datacenter) {
        super(uuid, name, VirtualMachineType.GENERIC, "", ip, publicIp, user, password, exists, isCloudStack, hostname, nodeName, networkId, machineId, diskspace, cpuCount, ramSize, status, parent != null ? parent.getUuid() : null, datacenter != null ? datacenter.getUuid() : null);
    }

    public VirtualMachine(VirtualMachineModel model) {
        super(model);
    }

    @Override
    public int compareTo(VirtualMachine vm) {
        return this.getUuid().compareTo(vm.getUuid());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VirtualMachine)) {
            return false;
        }
        VirtualMachine other = (VirtualMachine)obj;
        return this.getUuid().equals(other.getUuid());
    }

    public int hashCode() {
        return this.getUuid().hashCode();
    }

    @Override
    public boolean deploy() {
        return false;
    }

    @Override
    public boolean configure() {
        block10: {
            boolean rtc;
            block9: {
                block8: {
                    logger.info("Begin ");
                    if (!ConfigurationManager.INSTANCE.isDebugMode() && !this.testPingMachine()) {
                        logger.severe(Messages.getString("Errors.ConnectionFailed"));
                        return false;
                    }
                    try {
                        ObjectMap chefServiceInput = new ObjectMap();
                        chefServiceInput.append("kind", (Object)ServiceInfoKind.CHEF_CLIENT);
                        chefServiceInput.append("tier", (Object)this.getTier());
                        ServiceConfiguration sc = new ServiceConfiguration(chefServiceInput, this.getEnvironment().equals("NONE"));
                        if (new ChefClientService(this, sc).call().booleanValue()) break block8;
                        logger.severe("Unable to start Chef Client service for machine: " + this.getName());
                        return false;
                    }
                    catch (Exception e) {
                        logger.severe(MessageFormat.format("Configuration of the machine {0} failed due to exception {1}", this.getName(), e.getMessage()));
                        return false;
                    }
                }
                if (this.processDiskVolume()) break block9;
                logger.severe("Error while configuring the disks in: " + this.getName());
                return false;
            }
            if (this.needsPublicIp()) {
                this.setupPublicIpAddress();
            }
            if (!this.needsGPFS() || (rtc = this.setupGPFS())) break block10;
            return false;
        }
        if (this.needsJavaDockerSoftware()) {
            return this.setupJavaDockerSoftware();
        }
        return true;
    }

    protected boolean needsPublicIp() {
        return false;
    }

    protected boolean needsJavaDockerSoftware() {
        return true;
    }

    protected boolean needsGPFS() {
        return false;
    }

    protected String getGPFSMountPoint() {
        return null;
    }

    protected int getGPFSDiskSpace() {
        return 0;
    }

    protected boolean needsGPFSEncryption() {
        return false;
    }

    public boolean processDiskVolume() {
        boolean res = true;
        if (this.getDiskspace() > this.getTemplateDiskspace()) {
            logger.info("The disk will be increased, Default: " + this.getTemplateDiskspace() + " Required: " + this.getDiskspace());
            res = ChefManager.runCookBook(this.getIp(), this.getUser(), this.getPassword(), null, Cookbook.MERGE_VOLUMES, this.getName());
            if (!res) {
                logger.log(Level.SEVERE, Messages.getString("Errors.ChefCookbook"), new Object[]{"RESIZEDISK", this.getName(), this.getIp()});
            }
        } else {
            logger.info("The disk will not changed current size: " + this.getDiskspace() + " new size: " + this.getTemplateDiskspace());
        }
        return res;
    }

    public boolean setupGPFS() {
        int gpfsDiskSpace = this.getGPFSDiskSpace();
        if (gpfsDiskSpace == 0) {
            logger.severe("Diskspace for GPFS is 0.  Skip GPFS setup");
            return false;
        }
        String gpfsMountPoint = this.getGPFSMountPoint();
        if (gpfsMountPoint == null) {
            logger.severe("GPFS MountPoint is not specified.  Skip GPFS setup");
            return false;
        }
        logger.info(MessageFormat.format("Configure GPFS in {0}", this.getName()));
        boolean result = true;
        try {
            ObjectMap paramGPFS = new ObjectMap();
            paramGPFS.append("MOUNT_POINT", (Object)this.getGPFSMountPoint());
            logger.info(MessageFormat.format("GPFS filesystem will be mounted on {0}", this.getGPFSMountPoint()));
            logger.info(MessageFormat.format("Running GPFS cookbook in {0}", this.getName()));
            result = ChefManager.runCookBook(this.getIp(), this.getUser(), this.getPassword(), paramGPFS, Cookbook.GPFS, this.getName());
            if (!result) {
                logger.severe("Failed to run GPFS cookbook on: " + this.getName());
            }
        }
        catch (InvalidParameterException e) {
            logger.severe(e.toString());
            result = false;
        }
        return result;
    }

    @Override
    public boolean verify() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public ObjectMap toObjectMap() {
        ObjectMap result = null;
        try {
            result = StorageUtils.toObjectMap(new VirtualMachineModel(this));
        }
        catch (ParseException | SerializeException e) {
            logger.severe(MessageFormat.format("Failed to serialize VirtualMachine {} to JSON due to {1}", this.getName(), e));
        }
        return result;
    }

    protected boolean testPingMachine() {
        try {
            logger.info("Trying to connect to: " + this.getIp());
            InetAddress ipAddress = InetAddress.getByName(this.getIp());
            logger.info("Address: " + ipAddress.toString());
            return ipAddress.isReachable(30000);
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected String getTier() {
        return "NONE";
    }

    public boolean waitTillReady() throws SSHCommandException {
        boolean result = this.waitForPing();
        if (result) {
            result = SSHUtils.testSSHConnectionToMachine(this.getIp(), this.getUser(), this.getPassword(), ConfigurationManager.INSTANCE.getSshTimeout());
        }
        return result;
    }

    private boolean waitForPing() {
        return this.waitFor(new IActionToWait(){

            @Override
            public boolean action() {
                return VirtualMachine.this.testPingMachine();
            }
        });
    }

    public boolean waitFor(IActionToWait callback) {
        return this.waitFor(callback, 1000L);
    }

    public boolean waitFor(IActionToWait callback, long sleepTime) {
        boolean result = false;
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)ConfigurationManager.INSTANCE.getPingTimeout().intValue() * 1000L;
        while (System.currentTimeMillis() < endTime) {
            if (callback.action()) {
                result = true;
                break;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result;
    }

    public String setupPublicIpAddress() {
        String ip = null;
        if (this.getIsCloudStack().booleanValue()) {
            String networkId = InfrastructureManager.INSTANCE.getDataCenter().getNetworkId();
            String envUuid = this.getEnvironment();
            if (envUuid != null && !envUuid.equals("NONE")) {
                networkId = ElasticManager.INSTANCE.getQueryManager().getEnvironmentByUuid(envUuid).getNetworkId();
            }
            logger.info("Setting public IP in the network id: " + networkId);
            try {
                ip = CloudStackCommandManager.INSTANCE.setupPublicIPforMachine(InfrastructureManager.INSTANCE.getDataCenter().getVpcId(), networkId, this.getName());
                if (ip == null) {
                    logger.severe("Error CloudStack unable to assign public IP to " + this.getName());
                } else {
                    this.setPublicIp(ip);
                    logger.info("Public IP " + ip + " to " + this.getName());
                    ElasticManager.INSTANCE.getStorageManager().update(this);
                }
            }
            catch (CloudStackCommandException e) {
                logger.severe("Error executing setup Public IP command via CloudStack. Error: " + e.getMessage());
            }
        }
        return ip;
    }

    public Map.Entry<String, Boolean> checkResults(List<Map.Entry<String, Boolean>> results) {
        for (Map.Entry<String, Boolean> entry : results) {
            if (entry.getValue().booleanValue()) continue;
            return entry;
        }
        return null;
    }

    @Override
    public boolean delete(boolean ignoreErrors, boolean cleanupElasticSearch) {
        boolean success = true;
        this.setStatus(VirtualMachineStatus.STOPPED);
        ElasticManager.INSTANCE.getStorageManager().update(this);
        try {
            ObjectList machines = CloudStackCommandManager.INSTANCE.findVirtualMachinesById(this.getMachineId());
            if (machines.isEmpty()) {
                logger.warning(MessageFormat.format("Virtual machine with id {0} has already been removed from CloudStack", this.getMachineId()));
            } else {
                if (!ConfigurationManager.INSTANCE.isDebugMode()) {
                    logger.info("Deleting the chef node: " + this.getName());
                    ChefManager.deleteNode(this.getName(), this.getIp());
                }
                CloudStackUtils.destroyAndExpungeVirtualMachineWithAllDatadisk(this.getMachineId());
            }
        }
        catch (CloudStackCommandException e) {
            logger.severe(MessageFormat.format("Unable to delete virtual machine {0} from CloudStack due to {1}", this.getName(), e));
            success = false;
        }
        if (!ignoreErrors && !success) {
            return false;
        }
        ServiceManager.INSTANCE.initializeLocks(this);
        if (cleanupElasticSearch) {
            List<ServiceInfoModel> services = ElasticManager.INSTANCE.getQueryManager().getServicesByVirtualMachine(this.getUuid());
            if (services != null) {
                for (ServiceInfoModel service : services) {
                    if (ElasticManager.INSTANCE.getStorageManager().delete(service)) continue;
                    logger.severe(MessageFormat.format("Deleting services running on virtual machine {0}: problem removing service: {1}", this.getName(), service.getName()));
                }
            }
            success = ElasticManager.INSTANCE.getStorageManager().delete(this);
        }
        return success;
    }

    public boolean reboot() {
        boolean success = true;
        this.setStatus(VirtualMachineStatus.REBOOTING);
        ElasticManager.INSTANCE.getStorageManager().update(this);
        try {
            ObjectList machines = CloudStackCommandManager.INSTANCE.findVirtualMachinesById(this.getMachineId());
            if (machines.isEmpty()) {
                logger.warning(MessageFormat.format("Virtual machine with id {0} doesn't exist in CloudStack. Unable to reboot it.", this.getMachineId()));
            } else {
                CloudStackCommandManager.INSTANCE.rebootVirtualMachine(this.getMachineId());
            }
        }
        catch (CloudStackCommandException e) {
            logger.severe(MessageFormat.format("Unable to reboot virtual machine {0} from CloudStack due to {1}", this.getName(), e));
            success = false;
        }
        try {
            if (this.waitTillReady()) {
                this.setStatus(VirtualMachineStatus.RUNNING);
                ElasticManager.INSTANCE.getStorageManager().update(this);
            } else {
                success = false;
            }
        }
        catch (SSHCommandException e) {
            logger.fine(MessageFormat.format("Problem connecting to a machine {0} after reboot due to {1}", this.getName(), e));
            success = false;
        }
        return success;
    }

    protected String getVerifyParameters() {
        return this.getIp();
    }

    protected boolean doVerify(String scriptName) {
        String scriptLocation = InfrastructureManager.INSTANCE.getVerifyScriptFilePath(this, "/" + scriptName, true);
        if (scriptLocation == null) {
            throw new UnsupportedOperationException(MessageFormat.format("Unable to locate verification script: {0}. Check infrastructure microservice log for details", scriptName));
        }
        File scriptFile = new File(scriptLocation);
        if (!scriptFile.exists()) {
            throw new UnsupportedOperationException(MessageFormat.format("Unable to find verification script file located at: {0}. Check infrastructure microservice log for details", scriptLocation));
        }
        scriptFile.setExecutable(true);
        int result = 0;
        String command = String.valueOf(scriptLocation) + " " + this.getVerifyParameters();
        try {
            result = CommandUtils.runCommand(command, logger);
        }
        catch (IOException | InterruptedException e) {
            throw new UnsupportedOperationException("Failed to run verification script. Check infrastructure microservice log for details due to " + e.getMessage());
        }
        if (result == 0) {
            logger.info(MessageFormat.format("Configuration of the machine {0} has been verified successfully.", this.getName()));
            return true;
        }
        logger.warning(MessageFormat.format("Configuration of the machine {0} did not pass verification test.", this.getName()));
        return false;
    }

    protected boolean setupJavaDockerSoftware() {
        boolean result = true;
        try {
            String registryUrl = String.valueOf(ConfigurationManager.INSTANCE.getDockerRegistryHost()) + ":" + ConfigurationManager.INSTANCE.getDockerRegistryPort();
            String serverNFS = String.valueOf(ConfigurationManager.INSTANCE.getAdminMachineHost()) + ":" + ConfigurationManager.INSTANCE.getAdminMachineArtifactPath();
            boolean enableNmon = ConfigurationManager.INSTANCE.getNmon();
            ObjectMap paramDocker = new ObjectMap();
            paramDocker.append("DOCKER_REGISTRY", (Object)registryUrl);
            paramDocker.append("NFS_SERVER", (Object)serverNFS);
            paramDocker.append("NMON", (Object)enableNmon);
            logger.info("serverNFS = " + serverNFS);
            logger.info("Running the Java and Docker config");
            result = ChefManager.runCookBook(this.getIp(), this.getUser(), this.getPassword(), paramDocker, Cookbook.CONFIGUREJAVADOCKER, this.getName());
            if (!result) {
                logger.severe("Failed to configure Java and Docker software on: " + this.getName());
            }
        }
        catch (InvalidParameterException e) {
            logger.severe(e.toString());
            result = false;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean executeServices(List<Callable<Boolean>> services) {
        try {
            Callable<Boolean> callable;
            IService service;
            ThreadUtils.executeTasks(services);
            Iterator<Callable<Boolean>> iterator = services.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((service = (IService)(callable = iterator.next())).getStatus().isSuccess());
            return false;
        }
        catch (ServiceException e) {
            logger.severe("Running services configuration failed due to: " + e.getMessage());
        }
        return true;
    }

    public String getScriptsWorkspaceFolder() {
        return "../com.ibm.team.serviceability.automation.chef/scripts";
    }
}

