/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.deployment.api.systems;

import com.ibm.juno.core.ObjectList;
import com.ibm.juno.core.ObjectMap;
import com.ibm.juno.core.parser.ParseException;
import com.ibm.juno.core.serializer.SerializeException;
import com.ibm.juno.core.utils.StringUtils;
import com.ibm.team.serviceability.cloudstack.client.CloudStackCommandManager;
import com.ibm.team.serviceability.cloudstack.client.command.CloudStackCommandException;
import com.ibm.team.serviceability.datamodel.deployment.datacenter.DataCenterModel;
import com.ibm.team.serviceability.datamodel.deployment.environments.EnvironmentModel;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoKind;
import com.ibm.team.serviceability.datamodel.storage.StorageUtils;
import com.ibm.team.serviceability.deployment.api.managers.ConfigurationManager;
import com.ibm.team.serviceability.deployment.api.managers.DefaultSystemNameGenerator;
import com.ibm.team.serviceability.deployment.api.managers.ISystemManager;
import com.ibm.team.serviceability.deployment.api.managers.JobManager;
import com.ibm.team.serviceability.deployment.api.managers.SystemManagerFactory;
import com.ibm.team.serviceability.deployment.api.managers.TierManager;
import com.ibm.team.serviceability.deployment.api.managers.storage.ElasticManager;
import com.ibm.team.serviceability.deployment.api.softlayer.DNSEntryHelper;
import com.ibm.team.serviceability.deployment.api.systems.Environment;
import com.ibm.team.serviceability.deployment.api.systems.IInfrastructureObject;
import com.ibm.team.serviceability.deployment.api.systems.VirtualMachine;
import com.ibm.team.serviceability.deployment.api.utils.JobStatus;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;

public class DataCenter
extends DataCenterModel
implements IInfrastructureObject {
    private static final Logger logger = Logger.getLogger(DataCenter.class.getName());
    private String jobId = null;

    public DataCenter(String uuid, String shortName, String name, String description, String vpcId, String vpcName, String cidr, String domainName, String networkId) {
        super(uuid, shortName, name, description, vpcId, vpcName, cidr, domainName, networkId);
        this.computeValues();
    }

    public DataCenter(DataCenterModel dataCenterModel) {
        super(dataCenterModel);
        this.computeValues();
    }

    private void computeValues() {
        String vpcName = this.getVpcName();
        String shortName = this.getShortName();
        String cidr = this.getCidr();
        String domainName = this.getDomainName();
        this.setVpcName(StringUtils.isEmpty((String)vpcName) ? DefaultSystemNameGenerator.INSTANCE.getDefaultVpcName(shortName) : vpcName);
        this.setCidr(StringUtils.isEmpty((String)cidr) ? DefaultSystemNameGenerator.INSTANCE.getDefaultDataCenterCidr() : cidr);
        this.setDomainName(StringUtils.isEmpty((String)domainName) ? DefaultSystemNameGenerator.INSTANCE.getDefaultDomainName(shortName) : domainName);
    }

    @Override
    public boolean deploy() {
        ISystemManager systemManager = SystemManagerFactory.INSTANCE.getManager(this);
        return systemManager.createDataCenter(this);
    }

    @Override
    public boolean configure() {
        return true;
    }

    @Override
    public boolean verify() {
        return true;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public ObjectMap toObjectMap() {
        ObjectMap result = null;
        try {
            result = StorageUtils.toObjectMap(new DataCenterModel(this));
        }
        catch (ParseException | SerializeException e) {
            logger.severe("Failed to convert JSON datacenter to ObjectMap due to: " + e);
        }
        return result;
    }

    @Override
    public boolean delete(boolean ignoreErrors, boolean cleanupElasticSearch) {
        return this.delete(false, ignoreErrors, cleanupElasticSearch);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete(boolean remoteDelete, boolean ignoreErrors, boolean cleanupElasticSearch) {
        boolean success = true;
        JobStatus status = JobManager.INSTANCE.getStatus(this.getJobId());
        if (StringUtils.isEmpty((String)this.getNetworkId())) return success;
        try {
            int workSize;
            ObjectList vpcs = CloudStackCommandManager.INSTANCE.findVPCs(ConfigurationManager.INSTANCE.getZoneId(), this.getVpcName());
            if (vpcs.isEmpty()) {
                return success;
            }
            ObjectMap vpc = (ObjectMap)vpcs.get(0);
            String vpcId = vpc.getString("id");
            if (!vpcId.equals(this.getVpcId())) {
                logger.warning("Incorrect VPC id was stored for this OH!");
                this.setVpcId(vpcId);
            }
            ObjectList vmListFromCS = CloudStackCommandManager.INSTANCE.findVirtualMachinesByNameAndNetworkId(null, this.getNetworkId());
            List<VirtualMachine> vmListFromES = ElasticManager.INSTANCE.getQueryManager().getVirtualMachinesByEnvironment("NONE");
            String deployVMUUID = null;
            int n = workSize = remoteDelete ? 2 : 0;
            workSize = vmListFromES != null && !vmListFromES.isEmpty() ? (workSize += vmListFromES.size()) : (workSize += vmListFromCS.size());
            List<EnvironmentModel> envs = ElasticManager.INSTANCE.getQueryManager().getEnvironments();
            if (envs != null) {
                workSize += envs.size();
            }
            status.createProgressTracker(workSize);
            if (envs != null) {
                for (EnvironmentModel item : envs) {
                    Environment env = new Environment(item);
                    env.setJobId(JobManager.INSTANCE.getNewJobID());
                    status.setActivity("Deleting environment: " + env.getName());
                    env.delete(ignoreErrors, cleanupElasticSearch);
                    status.worked();
                }
            }
            status.setActivity("Deleting data center machines and network");
            if (vmListFromES != null) {
                VirtualMachine deployVM = TierManager.INSTANCE.getMachine(ServiceInfoKind.IFMS_SERVICE);
                if (deployVM != null) {
                    deployVMUUID = deployVM.getUuid();
                }
                if (!(success = DNSEntryHelper.INSTANCE.deleteSoftlayerDNSEntry()) && !ignoreErrors) {
                    return false;
                }
                for (VirtualMachine vm : vmListFromES) {
                    if (!remoteDelete && vm.getUuid().equals(deployVMUUID)) {
                        logger.info("Skipping removal of deploy vm: " + vm.getName());
                    } else {
                        status.setActivity(MessageFormat.format("Deleting machine {1}", this.getName(), vm.getName()));
                        success = vm.delete(ignoreErrors, cleanupElasticSearch);
                        if (!success && !ignoreErrors) {
                            return false;
                        }
                    }
                    status.worked();
                }
            }
            if (remoteDelete) {
                ObjectList networks;
                status.setActivity(MessageFormat.format("Deleting platform virtual machines and network {0}", this.getNetworkId()));
                vmListFromCS = CloudStackCommandManager.INSTANCE.findVirtualMachinesByNameAndNetworkId(null, this.getNetworkId());
                if (!vmListFromCS.isEmpty()) {
                    if (CloudStackCommandManager.INSTANCE.deleteNetworkWithMachines(this.getNetworkId()).booleanValue()) {
                        logger.info(MessageFormat.format("Successfully deleted data center {0} virtual machines that were not published to ES.", this.getName()));
                        status.worked(vmListFromCS.size() + 1);
                    } else {
                        String message = MessageFormat.format("Failed to forcefully remove data center {0}", this.getName());
                        logger.severe(message);
                        success = false;
                    }
                } else {
                    networks = CloudStackCommandManager.INSTANCE.findNetworkById(this.getNetworkId());
                    if (networks.isEmpty()) {
                        logger.warning(MessageFormat.format("Data center guest network with id {0} has already been deleted from CloudStack", this.getNetworkId()));
                    } else {
                        success = CloudStackCommandManager.INSTANCE.deleteNetwork(this.getNetworkId());
                    }
                }
                status.worked();
                networks = CloudStackCommandManager.INSTANCE.findNetworks(ConfigurationManager.INSTANCE.getZoneId(), this.getVpcId());
                if (!networks.isEmpty()) {
                    for (Object networkObj : networks) {
                        ObjectMap network = (ObjectMap)networkObj;
                        CloudStackCommandManager.INSTANCE.deleteNetworkWithMachines(network.getString("id"));
                    }
                }
                status.setActivity(MessageFormat.format("Deleting data center VPC {0}", this.getName()));
                CloudStackCommandManager.INSTANCE.deleteVPC(this.getVpcId());
                status.worked();
                if (cleanupElasticSearch) {
                    success = ElasticManager.INSTANCE.getStorageManager().delete(this);
                }
            }
            status.setActivity(MessageFormat.format("Data Center {0} has been successfully deleted", this.getName()));
            return success;
        }
        catch (CloudStackCommandException e) {
            logger.severe(MessageFormat.format("Unable to delete data center {0} from CloudStack due to: {1}", this.getName(), e));
            return false;
        }
    }
}

