/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.deployment.api.systems;

import com.ibm.team.serviceability.datamodel.deployment.vm.VirtualMachineModel;
import com.ibm.team.serviceability.deployment.api.managers.ServiceManager;
import com.ibm.team.serviceability.deployment.api.managers.vmtopology.MachineConfiguration;
import com.ibm.team.serviceability.deployment.api.managers.vmtopology.ServiceConfiguration;
import com.ibm.team.serviceability.deployment.api.services.IService;
import com.ibm.team.serviceability.deployment.api.systems.VirtualMachine;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class ContainerMachine
extends VirtualMachine {
    private static final Logger logger = Logger.getLogger(ContainerMachine.class.getName());
    public MachineConfiguration configuration = null;

    public ContainerMachine(VirtualMachineModel vm, Object configuration) {
        super(vm);
        this.configuration = (MachineConfiguration)configuration;
    }

    @Override
    public boolean configure() {
        logger.info("Begin configuring machine: " + this.getName());
        if (!super.configure()) {
            logger.severe(MessageFormat.format("Failed to configure {0} machine: {1}", new Object[]{this.getType(), this.getName()}));
            return false;
        }
        ArrayList<Callable<Boolean>> services = new ArrayList<Callable<Boolean>>();
        logger.info(MessageFormat.format("Discovered {0} services defined on machine: {1}", this.configuration.getServices().size(), this.getName()));
        for (ServiceConfiguration serviceConfig : this.configuration.getServices()) {
            IService service = ServiceManager.INSTANCE.createMachineService(serviceConfig, this);
            if (service != null) {
                services.add(service);
                logger.info(MessageFormat.format("Successfully registered service {0} for machine {1}", serviceConfig.getKind(), this.getName()));
                continue;
            }
            logger.warning(MessageFormat.format("Unable to map service kind {0} to an implementation. Skipped creation of the service", serviceConfig.getKind()));
        }
        logger.info(MessageFormat.format("Launched execution of service configuration of {0} services for machine {1}", services.size(), this.getName()));
        boolean result = true;
        if (!services.isEmpty()) {
            result = ContainerMachine.executeServices(services);
        }
        if (result) {
            logger.info("Finished configuring machine: " + this.getName() + " successfully.");
        }
        return result;
    }

    @Override
    protected boolean needsPublicIp() {
        return this.configuration.isNeedsPublicIp();
    }

    @Override
    protected boolean needsJavaDockerSoftware() {
        return this.configuration.isNeedsJavaDocker();
    }

    @Override
    protected boolean needsGPFS() {
        return this.configuration.isNeedsGPFS();
    }

    @Override
    protected String getGPFSMountPoint() {
        return this.configuration.getGPFSMountPoint();
    }

    @Override
    protected int getGPFSDiskSpace() {
        return this.configuration.getGPFSDiskSpace();
    }

    @Override
    protected boolean needsGPFSEncryption() {
        return this.configuration.isNeedsGPFSEncryption();
    }

    @Override
    public boolean verify() {
        logger.info("Verifying machine: " + this.getName());
        if (this.configuration.getVerifyScripts().isEmpty()) {
            throw new UnsupportedOperationException("Verify scripts were not provided for machine: " + this.getName());
        }
        for (String script : this.configuration.getVerifyScripts()) {
            if (this.doVerify(script)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ContainerMachine cm = (ContainerMachine)obj;
        return this.configuration.equals(cm.configuration);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

