/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.deployment.api.services;

import com.ibm.juno.core.ObjectMap;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoKind;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoModel;
import com.ibm.team.serviceability.deployment.api.Messages;
import com.ibm.team.serviceability.deployment.api.chef.ChefManager;
import com.ibm.team.serviceability.deployment.api.chef.Cookbook;
import com.ibm.team.serviceability.deployment.api.managers.ConfigurationManager;
import com.ibm.team.serviceability.deployment.api.managers.InfrastructureManager;
import com.ibm.team.serviceability.deployment.api.managers.ServiceManager;
import com.ibm.team.serviceability.deployment.api.managers.vmtopology.ServiceConfiguration;
import com.ibm.team.serviceability.deployment.api.services.AbstractService;
import com.ibm.team.serviceability.deployment.api.services.ServiceException;
import com.ibm.team.serviceability.deployment.api.systems.VirtualMachine;
import java.util.ArrayList;
import java.util.logging.Logger;

public class RegistryService
extends AbstractService {
    public static final String REGISTRY_PORT = "6000";
    private static final Logger logger = Logger.getLogger(RegistryService.class.getName());

    public RegistryService(VirtualMachine vm, ServiceConfiguration sc) {
        super(vm, sc);
    }

    @Override
    protected void doConfigure() throws ServiceException {
        ObjectMap paramRegistry = new ObjectMap();
        paramRegistry.append("dockerRegistry", (Object)this.getRegistryUrl());
        paramRegistry.append("path", (Object)ConfigurationManager.INSTANCE.getDockerRegistryPath());
        paramRegistry.append("dockerRegistryInternal", (Object)ConfigurationManager.INSTANCE.getDockerRegistryInternal());
        logger.info("registryUrl = " + this.getRegistryUrl());
        logger.info("registryPort = 6000");
        if (!ChefManager.runCookBook(this.vm.getIp(), this.vm.getUser(), this.vm.getPassword(), paramRegistry, Cookbook.REGISTRY, this.vm.getName())) {
            throw new ServiceException("Failed to run cookbook to configure registry service on " + this.vm.getName());
        }
        ArrayList<ServiceInfoModel> services = new ArrayList<ServiceInfoModel>();
        ServiceInfoModel registryContainer = ServiceManager.INSTANCE.generateServiceInfo(Messages.getString("Service.REGISTRY_NAME"), Messages.getString("Service.REGISTRY_DESCRIPTION"), "Provisioning", ServiceInfoKind.REGISTRY, null, this.vm);
        services.add(ServiceManager.INSTANCE.generateServiceInfo(Messages.getString("Service.REGISTRY_SERVICE_NAME"), Messages.getString("Service.REGISTRY_SERVICE_DESCRIPTION"), "Provisioning", ServiceInfoKind.REGISTRY_SERVICE, registryContainer.getUuid(), this.vm));
        services.add(registryContainer);
        if (!ServiceManager.INSTANCE.updateAndRunServices(services, this.vm)) {
            throw new ServiceException("Failed to launch registry services on " + this.vm.getName());
        }
    }

    public String getRegistryUrl() {
        return String.valueOf(this.vm.getName()) + "." + InfrastructureManager.INSTANCE.getDataCenter().getDomainName() + ":" + REGISTRY_PORT;
    }

    @Override
    public ServiceInfoKind getKind() {
        return ServiceInfoKind.REGISTRY_SERVICE;
    }

    @Override
    protected String getServiceDescription() {
        return "configure Registry services";
    }
}

