/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.deployment.api.services;

import com.ibm.juno.core.ObjectMap;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoKind;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoModel;
import com.ibm.team.serviceability.deployment.api.Messages;
import com.ibm.team.serviceability.deployment.api.chef.ChefManager;
import com.ibm.team.serviceability.deployment.api.chef.Cookbook;
import com.ibm.team.serviceability.deployment.api.managers.ConfigurationManager;
import com.ibm.team.serviceability.deployment.api.managers.ServiceManager;
import com.ibm.team.serviceability.deployment.api.managers.storage.ElasticManager;
import com.ibm.team.serviceability.deployment.api.managers.vmtopology.ServiceConfiguration;
import com.ibm.team.serviceability.deployment.api.services.AbstractService;
import com.ibm.team.serviceability.deployment.api.services.ServiceException;
import com.ibm.team.serviceability.deployment.api.systems.VirtualMachine;
import com.ibm.team.serviceability.deployment.api.utils.IActionToWait;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class OpsDataStoreApiService
extends AbstractService {
    private static final Logger logger = Logger.getLogger(OpsDataStoreApiService.class.getName());

    public OpsDataStoreApiService(VirtualMachine vm, ServiceConfiguration sc) {
        super(vm, sc);
    }

    @Override
    protected void doConfigure() throws ServiceException {
        this.waitForPlatformServices(Arrays.asList(ServiceInfoKind.ES_SERVICE, ServiceInfoKind.REGISTRY_SERVICE), this.getServiceDescription());
        this.waitForColocatedServices(Arrays.asList(ServiceInfoKind.K8S_CONTROLLER_SERVICE), this.getServiceDescription());
        this.waitForPlatformServices(Arrays.asList(ServiceInfoKind.REGISTRY_SERVICE), this.getServiceDescription());
        String registryurl = String.valueOf(ConfigurationManager.INSTANCE.getDockerRegistryHost()) + ":" + ConfigurationManager.INSTANCE.getDockerRegistryPort();
        ObjectMap paramsElastic = new ObjectMap();
        paramsElastic.append("registry", (Object)registryurl);
        paramsElastic.append("DOCKER_IMAGE", (Object)ConfigurationManager.INSTANCE.getDockerImageOpsDataStoreApiPath());
        paramsElastic.append("DOCKER_TAG", (Object)ConfigurationManager.INSTANCE.getDockerImageOpsDataStoreApiTag());
        paramsElastic.append("K8S_NAMESPACE", (Object)this.getServiceConfiguration().getNamespace());
        paramsElastic.append("ES_HOST", (Object)ConfigurationManager.INSTANCE.getK8sOpsDataStoreServiceName());
        paramsElastic.append("ES_PORT", (Object)ConfigurationManager.INSTANCE.getElasticSearchPort());
        paramsElastic.append("SSA_PORT", (Object)ConfigurationManager.INSTANCE.getStoragePort());
        paramsElastic.append("QS_PORT", (Object)ConfigurationManager.INSTANCE.getQueryPort());
        paramsElastic.append("MDD_PORT", (Object)ConfigurationManager.INSTANCE.getMddPort());
        paramsElastic.append("MQTT_HOST", (Object)ConfigurationManager.INSTANCE.getK8sMQTTServiceName());
        paramsElastic.append("MQTT_PORT", (Object)ConfigurationManager.INSTANCE.getMqttPort());
        if (!ChefManager.runCookBook(this.vm.getIp(), this.vm.getUser(), this.vm.getPassword(), paramsElastic, Cookbook.OPSDATASTOREAPI, this.vm.getName())) {
            throw new ServiceException("Failed to run prepare ES container service on machine: " + this.vm.getName());
        }
        ArrayList<ServiceInfoModel> services = new ArrayList<ServiceInfoModel>();
        ServiceInfoModel container = ServiceManager.INSTANCE.generateServiceInfo(Messages.getString("Service.OPSDATASTOREAPI_NAME"), Messages.getString("Service.OPSDATASTOREAPI_DESCRIPTION"), "Storage", ServiceInfoKind.OPSDATASTOREAPI, null, this.vm);
        services.add(ServiceManager.INSTANCE.generateServiceInfo(Messages.getString("Service.SSA_NAME"), Messages.getString("Service.SSA_DESCRIPTION"), "Storage", ServiceInfoKind.SSA_SERVICE, container.getUuid(), this.vm));
        services.add(ServiceManager.INSTANCE.generateServiceInfo(Messages.getString("Service.QS_NAME"), Messages.getString("Service.QS_DESCRIPTION"), "Storage", ServiceInfoKind.QS_SERVICE, container.getUuid(), this.vm));
        services.add(ServiceManager.INSTANCE.generateServiceInfo(Messages.getString("Service.MDD_NAME"), Messages.getString("Service.MDD_DESCRIPTION"), "Storage", ServiceInfoKind.MDD_SERVICE, container.getUuid(), this.vm));
        services.add(container);
        if (!ServiceManager.INSTANCE.updateAndRunServices(services, this.vm)) {
            throw new ServiceException("Failed to launch the Ops DataStore API services on machine: " + this.vm.getName());
        }
        if (!this.connectToStorageServices(this.getVM().getEnvironment())) {
            throw new ServiceException("Unable to connect to storage services during configure of elastic machine: " + this.vm.getName());
        }
    }

    private boolean connectToStorageServices(final String envUuid) {
        if (ConfigurationManager.INSTANCE.isDebugMode()) {
            return true;
        }
        boolean result = true;
        try {
            logger.info(MessageFormat.format("Attempting to connect to QS service on VM {0} located in {1}", this.vm.getName(), envUuid.equals("NONE") ? "platform tier" : "environment " + envUuid));
            result = this.vm.waitFor(new IActionToWait(){

                @Override
                public boolean action() {
                    return ElasticManager.INSTANCE.getQueryManager(envUuid).initialize("https://" + OpsDataStoreApiService.this.vm.getIp() + ":" + ConfigurationManager.INSTANCE.getQueryPort(), "", "", envUuid.equals("NONE"), true);
                }
            }, 5000L);
            if (!result) {
                logger.severe("Unable to connect to QS service on Ops DataStore API machine: " + this.vm.getIp());
                return result;
            }
            logger.info("Successfully established connection to QS service on Ops DataStore API machine: " + this.vm.getIp());
        }
        catch (Exception e) {
            logger.severe(MessageFormat.format("Unexpected exception {0} happened during QS service connection on VM {1} located in {2}", e, this.vm.getName(), envUuid.equals("NONE") ? "platform tier" : "environment " + envUuid));
            return false;
        }
        try {
            logger.info(MessageFormat.format("Attempting to connect to SSA service on VM {0} located in {1}", this.vm.getName(), envUuid.equals("NONE") ? "platform tier" : "environment " + envUuid));
            result = this.vm.waitFor(new IActionToWait(){

                @Override
                public boolean action() {
                    return ElasticManager.INSTANCE.getStorageManager(envUuid).initialize("https://" + OpsDataStoreApiService.this.vm.getIp() + ":" + ConfigurationManager.INSTANCE.getStoragePort(), "", "", envUuid.equals("NONE"), true);
                }
            }, 5000L);
            if (!result) {
                logger.severe("Unable to connect to SSA service on Ops DataStore API machine: " + this.vm.getIp());
            } else {
                logger.info("Successfully established connection to SSA service on Ops DataStore API machine: " + this.vm.getIp());
            }
        }
        catch (Exception e) {
            logger.severe(MessageFormat.format("Unexpected exception {0} happened during SSA service connection on VM {1} located in {2}", e, this.vm.getName(), envUuid.equals("NONE") ? "platform tier" : "environment " + envUuid));
            return false;
        }
        return result;
    }

    @Override
    public ServiceInfoKind getKind() {
        return ServiceInfoKind.OPSDATASTOREAPI;
    }

    @Override
    protected String getServiceDescription() {
        return "configure Ops DataStore API services";
    }
}

