/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.deployment.api.services;

import com.ibm.juno.core.ObjectMap;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoKind;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoModel;
import com.ibm.team.serviceability.deployment.api.Messages;
import com.ibm.team.serviceability.deployment.api.chef.ChefManager;
import com.ibm.team.serviceability.deployment.api.chef.Cookbook;
import com.ibm.team.serviceability.deployment.api.managers.ConfigurationManager;
import com.ibm.team.serviceability.deployment.api.managers.ServiceManager;
import com.ibm.team.serviceability.deployment.api.managers.vmtopology.ServiceConfiguration;
import com.ibm.team.serviceability.deployment.api.services.AbstractService;
import com.ibm.team.serviceability.deployment.api.services.IService;
import com.ibm.team.serviceability.deployment.api.services.ServiceException;
import com.ibm.team.serviceability.deployment.api.systems.VirtualMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;

public class OperationConsoleService
extends AbstractService {
    private static final Logger logger = Logger.getLogger(OperationConsoleService.class.getName());

    public OperationConsoleService(VirtualMachine vm, ServiceConfiguration sc) {
        super(vm, sc);
    }

    @Override
    protected void doConfigure() throws ServiceException {
        Map<ServiceInfoKind, IService> platformDependencies = this.waitForPlatformServices(Arrays.asList(ServiceInfoKind.OPSDATASTOREAPI, ServiceInfoKind.IFMS_SERVICE, ServiceInfoKind.JAS_SERVICE, ServiceInfoKind.PROV_SERVICE, ServiceInfoKind.DOC_SERVICE, ServiceInfoKind.KIBANA_SERVICE, ServiceInfoKind.REGISTRY_SERVICE, ServiceInfoKind.HEARTBEAT_SERVICE), this.getServiceDescription());
        this.waitForColocatedServices(Arrays.asList(ServiceInfoKind.K8S_CONTROLLER_SERVICE), this.getServiceDescription());
        IService ifmsService = platformDependencies.get((Object)ServiceInfoKind.IFMS_SERVICE);
        IService jasService = platformDependencies.get((Object)ServiceInfoKind.JAS_SERVICE);
        IService provService = platformDependencies.get((Object)ServiceInfoKind.PROV_SERVICE);
        IService heartbeatService = platformDependencies.get((Object)ServiceInfoKind.HEARTBEAT_SERVICE);
        VirtualMachine deployMachine = ifmsService.getVM();
        if (deployMachine == null) {
            throw new ServiceException("Failed to retrieve deploy machine while configuring Operation Console service on : " + this.vm.getName());
        }
        logger.info("Successfully obtained IFMS service for machine: " + this.vm.getName());
        String nfs = String.valueOf(ConfigurationManager.INSTANCE.getAdminMachineHost()) + ":" + ConfigurationManager.INSTANCE.getAdminMachineArtifactPath();
        logger.info("Setting up Operation Console services");
        ObjectMap paramsOpsconsole = new ObjectMap();
        String registryUrl = String.valueOf(ConfigurationManager.INSTANCE.getDockerRegistryHost()) + ":" + ConfigurationManager.INSTANCE.getDockerRegistryPort();
        paramsOpsconsole.append("NFS_PATH", (Object)nfs);
        paramsOpsconsole.append("OPS_IMAGE", (Object)ConfigurationManager.INSTANCE.getDockerImageOpsPath());
        paramsOpsconsole.append("OPS_TAG", (Object)ConfigurationManager.INSTANCE.getDockerImageOpsTag());
        paramsOpsconsole.append("IFMS_PRIVATE_IP", (Object)ConfigurationManager.INSTANCE.getK8sDeploymentServiceName());
        paramsOpsconsole.append("OPSCONSOLE_PUBLIC_IP", (Object)(this.vm.getPublicIp() == null ? "opsconsoleip" : this.vm.getPublicIp()));
        paramsOpsconsole.append("REGISTRY_URL", (Object)registryUrl);
        paramsOpsconsole.append("REGISTRY_HOST", (Object)ConfigurationManager.INSTANCE.getDockerRegistryHost());
        paramsOpsconsole.append("REGISTRY_PORT", (Object)ConfigurationManager.INSTANCE.getDockerRegistryPort());
        paramsOpsconsole.append("JAS_IP", (Object)jasService.getVM().getPublicIp());
        paramsOpsconsole.append("PROV_PUBLIC_IP", (Object)provService.getVM().getPublicIp());
        paramsOpsconsole.append("HELP_IP", (Object)ConfigurationManager.INSTANCE.getK8sDocServiceName());
        paramsOpsconsole.append("HEARTBEAT_PORT", (Object)ConfigurationManager.INSTANCE.getHeartbeatPort());
        paramsOpsconsole.append("PROVISIONING_PORT", (Object)ConfigurationManager.INSTANCE.getProvisioningPort());
        paramsOpsconsole.append("OPS_PORT", (Object)ConfigurationManager.INSTANCE.getOpsConsolePort());
        paramsOpsconsole.append("DOC_PORT", (Object)ConfigurationManager.INSTANCE.getDocPort());
        paramsOpsconsole.append("QS_PORT", (Object)ConfigurationManager.INSTANCE.getQueryPort());
        paramsOpsconsole.append("SSA_PORT", (Object)ConfigurationManager.INSTANCE.getStoragePort());
        paramsOpsconsole.append("KUPA_PORT", (Object)ConfigurationManager.INSTANCE.getKupaPort());
        paramsOpsconsole.append("KUPA_USER", (Object)ConfigurationManager.INSTANCE.getKupaPassWord());
        paramsOpsconsole.append("KUPA_PASS", (Object)ConfigurationManager.INSTANCE.getKupaPassWord());
        paramsOpsconsole.append("PROXY_PORT", (Object)ConfigurationManager.INSTANCE.getProxyServicePort());
        paramsOpsconsole.append("MONITORING_IP", (Object)heartbeatService.getVM().getIp());
        paramsOpsconsole.append("BOOTSTRAP_IP", (Object)heartbeatService.getVM().getIp());
        if (!ChefManager.runCookBook(this.vm.getIp(), this.vm.getUser(), this.vm.getPassword(), paramsOpsconsole, Cookbook.OPSCONSOLE, this.vm.getName())) {
            throw new ServiceException("Failed to run cookbook to setup Ops console service on " + this.vm.getName());
        }
        ArrayList<ServiceInfoModel> services = new ArrayList<ServiceInfoModel>();
        ServiceInfoModel container = ServiceManager.INSTANCE.generateServiceInfo(Messages.getString("Service.OPS_NAME"), Messages.getString("Service.OPS_DESCRIPTION"), "Operations", ServiceInfoKind.OPS, null, this.vm);
        services.add(ServiceManager.INSTANCE.generateServiceInfo(Messages.getString("Service.OPS_SERVICE_NAME"), Messages.getString("Service.OPS_SERVICE_DESCRIPTION"), "Operations", ServiceInfoKind.OPS_SERVICE, container.getUuid(), this.vm));
        services.add(container);
        if (!ServiceManager.INSTANCE.updateAndRunServices(services, this.vm)) {
            throw new ServiceException("Failed to launch Ops console services on " + this.vm.getName());
        }
    }

    @Override
    public ServiceInfoKind getKind() {
        return ServiceInfoKind.OPS_SERVICE;
    }

    @Override
    protected String getServiceDescription() {
        return "configure Operation Console services";
    }
}

