/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.deployment.api.services;

import com.ibm.juno.core.ObjectMap;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoKind;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoModel;
import com.ibm.team.serviceability.deployment.api.Messages;
import com.ibm.team.serviceability.deployment.api.chef.ChefManager;
import com.ibm.team.serviceability.deployment.api.chef.Cookbook;
import com.ibm.team.serviceability.deployment.api.managers.ConfigurationManager;
import com.ibm.team.serviceability.deployment.api.managers.ServiceManager;
import com.ibm.team.serviceability.deployment.api.managers.vmtopology.ServiceConfiguration;
import com.ibm.team.serviceability.deployment.api.services.AbstractService;
import com.ibm.team.serviceability.deployment.api.services.ServiceException;
import com.ibm.team.serviceability.deployment.api.systems.VirtualMachine;
import java.util.Arrays;
import java.util.logging.Logger;

public class MonitoringService
extends AbstractService {
    private static final Logger logger = Logger.getLogger(MonitoringService.class.getName());

    public MonitoringService(VirtualMachine vm, ServiceConfiguration sc) {
        super(vm, sc);
    }

    @Override
    protected void doConfigure() throws ServiceException {
        this.waitForPlatformServices(Arrays.asList(ServiceInfoKind.REGISTRY_SERVICE), this.getServiceDescription());
        this.waitForColocatedServices(Arrays.asList(ServiceInfoKind.K8S_CONTROLLER_SERVICE), this.getServiceDescription());
        String registryurl = String.valueOf(ConfigurationManager.INSTANCE.getDockerRegistryHost()) + ":" + ConfigurationManager.INSTANCE.getDockerRegistryPort();
        ObjectMap paramMonitoring = new ObjectMap();
        paramMonitoring.append("registry", (Object)registryurl);
        paramMonitoring.append("IMG", (Object)ConfigurationManager.INSTANCE.getDockerImageClmPath());
        paramMonitoring.append("TAG", (Object)ConfigurationManager.INSTANCE.getDockerImageClmTag());
        logger.info("Running the monitoring cookbook");
        if (!ChefManager.runCookBook(this.vm.getIp(), this.vm.getUser(), this.vm.getPassword(), paramMonitoring, Cookbook.MONITORING, this.vm.getName())) {
            throw new ServiceException("Failed to setup monitoring service on " + this.vm.getName());
        }
        ServiceInfoModel monitoringService = ServiceManager.INSTANCE.generateServiceInfo(Messages.getString("Service.MONITORING_SERVICE_NAME"), Messages.getString("Service.MONITORING_SERVICE_DESCRIPTION"), "Application Administration", ServiceInfoKind.MONITORING_SERVICE, null, this.vm);
        if (!ServiceManager.INSTANCE.updateAndRunService(monitoringService, this.vm)) {
            throw new ServiceException("Failed to launch monitoring service on " + this.vm.getName());
        }
    }

    @Override
    public ServiceInfoKind getKind() {
        return ServiceInfoKind.MONITORING_SERVICE;
    }

    @Override
    protected String getServiceDescription() {
        return "configure monitoring services";
    }
}

