/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.deployment.api.services;

import com.ibm.juno.core.ObjectMap;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoKind;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoModel;
import com.ibm.team.serviceability.deployment.api.Messages;
import com.ibm.team.serviceability.deployment.api.chef.ChefManager;
import com.ibm.team.serviceability.deployment.api.chef.Cookbook;
import com.ibm.team.serviceability.deployment.api.managers.ConfigurationManager;
import com.ibm.team.serviceability.deployment.api.managers.InfrastructureManager;
import com.ibm.team.serviceability.deployment.api.managers.ServiceManager;
import com.ibm.team.serviceability.deployment.api.managers.vmtopology.ServiceConfiguration;
import com.ibm.team.serviceability.deployment.api.services.AbstractService;
import com.ibm.team.serviceability.deployment.api.services.ServiceException;
import com.ibm.team.serviceability.deployment.api.systems.VirtualMachine;

public class MasterService
extends AbstractService {
    public static final String MASTER_PORT = "8080";

    public MasterService(VirtualMachine vm, ServiceConfiguration sc) {
        super(vm, sc);
    }

    @Override
    protected void doConfigure() throws ServiceException {
        ObjectMap paramMaster = new ObjectMap();
        paramMaster.append("master", (Object)(String.valueOf(this.vm.getName()) + "." + InfrastructureManager.INSTANCE.getDataCenter().getDomainName()));
        paramMaster.append("ip", (Object)this.vm.getIp());
        paramMaster.append("port", (Object)MASTER_PORT);
        paramMaster.append("nfs", (Object)(String.valueOf(ConfigurationManager.INSTANCE.getAdminMachineHost()) + ":" + ConfigurationManager.INSTANCE.getAdminMachineArtifactPath()));
        if (!ChefManager.runCookBook(this.vm.getIp(), this.vm.getUser(), this.vm.getPassword(), paramMaster, Cookbook.MASTER, this.vm.getName())) {
            throw new ServiceException("Failed to setup Master service on " + this.vm.getName());
        }
        ServiceInfoModel kube = ServiceManager.INSTANCE.generateServiceInfo(Messages.getString("Service.KUBE_MASTER_NAME"), Messages.getString("Service.KUBE_MASTER_DESCRIPTION"), "Application Runtime", ServiceInfoKind.KUBE_MASTER, null, this.vm);
        if (!ServiceManager.INSTANCE.updateAndRunService(kube, this.vm)) {
            throw new ServiceException("Failed to launch Master service on " + this.vm.getName());
        }
    }

    @Override
    public ServiceInfoKind getKind() {
        return ServiceInfoKind.KUBE_MASTER;
    }

    @Override
    protected String getServiceDescription() {
        return "configure Master services";
    }
}

