/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.deployment.api.services;

import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoKind;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoModel;
import com.ibm.team.serviceability.deployment.api.Messages;
import com.ibm.team.serviceability.deployment.api.chef.ChefManager;
import com.ibm.team.serviceability.deployment.api.chef.Cookbook;
import com.ibm.team.serviceability.deployment.api.managers.ServiceManager;
import com.ibm.team.serviceability.deployment.api.managers.vmtopology.ServiceConfiguration;
import com.ibm.team.serviceability.deployment.api.services.AbstractService;
import com.ibm.team.serviceability.deployment.api.services.ServiceException;
import com.ibm.team.serviceability.deployment.api.systems.VirtualMachine;

public class ChefClientService
extends AbstractService {
    public ChefClientService(VirtualMachine vm, ServiceConfiguration sc) {
        super(vm, sc);
    }

    @Override
    protected void doConfigure() throws ServiceException {
        if (!ChefManager.addNode(this.vm.getIp(), this.vm.getUser(), this.vm.getPassword(), this.vm.getName())) {
            throw new ServiceException("Failed to add Chef node on " + this.vm.getName());
        }
        if (!ChefManager.runCookBook(this.vm.getIp(), this.vm.getUser(), this.vm.getPassword(), null, Cookbook.CONFIGURECHEFCLIENT, this.vm.getName())) {
            throw new ServiceException("Failed to configure chef client on " + this.vm.getName());
        }
        ServiceInfoModel chef = ServiceManager.INSTANCE.generateServiceInfo(Messages.getString("Service.CHEF_CLIENT_NAME"), Messages.getString("Service.CHEF_CLIENT_DESCRIPTION"), this.getServiceConfiguration().getTier(), ServiceInfoKind.CHEF_CLIENT, null, this.vm);
        if (!ServiceManager.INSTANCE.updateAndRunService(chef, this.vm)) {
            throw new ServiceException("Failed to launch Chef client service on " + this.vm.getName());
        }
    }

    @Override
    public ServiceInfoKind getKind() {
        return ServiceInfoKind.CHEF_CLIENT;
    }

    @Override
    protected String getServiceDescription() {
        return "installing Chef client service";
    }
}

