/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.deployment.api.managers;

import com.ibm.juno.core.ini.ConfigFile;
import com.ibm.juno.core.serializer.SerializeException;
import com.ibm.team.serviceability.cloudstack.client.CloudStackCommandManager;
import java.security.InvalidParameterException;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum ConfigurationManager {
    INSTANCE;

    private final Logger logger = Logger.getLogger(ConfigurationManager.class.getName());
    private boolean isDebugMode = false;
    private boolean isSelfTestMode = false;
    private ConfigFile configFile;
    private String apiUrl;
    private String secretKey;
    private String apiKey;
    private String zoneId;
    private String defaultVpcOfferingName;
    private String defaultNetworkOfferingName;
    private Integer defaultVMCpuSpeed;
    private Integer defaultVMCpuCount;
    private Integer defaultVMRamSize;
    private String defaultVMTemplateName = null;
    private Integer defaultSubnetPrefix;
    private String adminMachineHost;

    void initialize(ConfigFile cf) {
        String value;
        this.configFile = cf;
        this.apiUrl = cf.getString("CloudStack/apiUrl");
        this.apiKey = cf.getString("CloudStack/apiKey");
        this.secretKey = cf.getString("CloudStack/secretKey");
        this.zoneId = cf.getString("CloudStack/zoneId");
        this.defaultVpcOfferingName = cf.getString("CloudStack/defaultVPCOfferingName");
        this.defaultNetworkOfferingName = cf.getString("CloudStack/defaultNetworkOfferingName");
        this.defaultSubnetPrefix = cf.getInt("CloudStack/defaultSubnetPrefix");
        this.defaultVMCpuSpeed = cf.getInt("CloudStack/defaultCpuSpeed", 1);
        this.defaultVMRamSize = cf.getInt("CloudStack/defaultRamSize", 1);
        this.defaultVMCpuCount = cf.getInt("CloudStack/defaultCpuCount", 80);
        this.defaultVMTemplateName = cf.getString("CloudStack/defaultVMTemplateName");
        this.adminMachineHost = cf.getString("Infrastructure/adminMachineHost");
        if (this.apiUrl == null) {
            this.logger.log(Level.SEVERE, "CloudStack/apiUrl is not defined in deployment.cfg. Access to CloudStack functionality is blocked.");
            throw new InvalidParameterException("CloudStack/apiUrl is not defined in deployment.cfg");
        }
        if (this.apiKey == null) {
            this.logger.log(Level.SEVERE, "CloudStack/apiKey is not defined in deployment.cfg. Access to CloudStack functionality is blocked.");
            throw new InvalidParameterException("CloudStack/apiKey is not defined in deployment.cfg");
        }
        if (this.secretKey == null) {
            this.logger.log(Level.SEVERE, "CloudStack/secretKey is not defined in deployment.cfg. Access to CloudStack functionality is blocked.");
            throw new InvalidParameterException("CloudStack/secretKey is not defined in deployment.cfg");
        }
        if (this.zoneId == null) {
            this.logger.log(Level.SEVERE, "CloudStack/zoneId is not defined in deployment.cfg. Access to CloudStack functionality is blocked.");
            throw new InvalidParameterException("CloudStack/zoneId is not defined in deployment.cfg");
        }
        if (this.defaultVpcOfferingName == null) {
            this.logger.log(Level.SEVERE, "CloudStack/defaultVpcOfferingName is not defined in deployment.cfg. Some CloudStack functionality is blocked.");
            throw new InvalidParameterException("CloudStack/defaultVpcOfferingName is not defined in deployment.cfg");
        }
        if (this.defaultNetworkOfferingName == null) {
            this.logger.log(Level.SEVERE, "CloudStack/defaultNetworkOfferingName is not defined in deployment.cfg. Some CloudStack functionality is blocked.");
            throw new InvalidParameterException("CloudStack/defaultNetworkOfferingName is not defined in deployment.cfg");
        }
        if (this.defaultSubnetPrefix == null) {
            this.logger.log(Level.SEVERE, "CloudStack/defaultSubnetPrefix is not defined in deployment.cfg. Some CloudStack functionality is blocked.");
            throw new InvalidParameterException("CloudStack/defaultSubnetPrefix is not defined in deployment.cfg");
        }
        if (this.adminMachineHost == null) {
            this.logger.log(Level.WARNING, "CloudStack/adminMachineHost is not defined in deployment.cfg. Infrastructure microservice may not be able to configure some of the machines.");
        }
        this.isDebugMode = (value = System.getProperty("IFMS_DEBUG")) != null ? Boolean.valueOf(value) : false;
        value = System.getProperty("IFMS_TEST");
        this.isSelfTestMode = value != null ? Boolean.valueOf(value) : false;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public boolean isSelfTestMode() {
        return this.isSelfTestMode;
    }

    public boolean initialize(String url, String apikey, String secretkey, String zoneid) {
        try {
            this.setApiUrl(url);
            this.setApiKey(apikey);
            this.setSecretKey(secretkey);
            this.setZoneId(zoneid);
            CloudStackCommandManager.INSTANCE.initialize(url, apikey, secretkey);
        }
        catch (SerializeException e) {
            return false;
        }
        return true;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    private void setApiUrl(String apiUrl) throws SerializeException {
        this.apiUrl = apiUrl;
        this.configFile.put("CloudStack/apiUrl", (Object)apiUrl);
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    private void setSecretKey(String value) throws SerializeException {
        this.secretKey = value;
        this.configFile.put("CloudStack/secretKey", (Object)value);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    private void setApiKey(String value) throws SerializeException {
        this.apiKey = value;
        this.configFile.put("CloudStack/apiKey", (Object)value);
    }

    public String getZoneId() {
        return this.zoneId;
    }

    private void setZoneId(String value) throws SerializeException {
        this.zoneId = value;
        this.configFile.put("CloudStack/zoneId", (Object)value);
    }

    public String getVPCOfferingName() {
        return this.defaultVpcOfferingName;
    }

    public String getDefaultNetworkOfferingName() {
        return this.defaultNetworkOfferingName;
    }

    public int getDefaultCpuCount() {
        return this.defaultVMCpuCount;
    }

    public int getDefaultCpuSpeed() {
        return this.defaultVMCpuSpeed;
    }

    public int getDefaultRamSize() {
        return this.defaultVMRamSize;
    }

    public String getDefaultVMTemplateName() {
        return this.defaultVMTemplateName;
    }

    public int getDefaultSubnetPrefix() {
        return this.defaultSubnetPrefix;
    }

    public String getAdminMachineHost() {
        return this.adminMachineHost;
    }

    public Integer getInstanceDeleteTimeout() {
        return this.configFile.getInt("KUPA/instanceDeleteTimeout", 300000);
    }

    public Integer getPingTimeout() {
        return this.configFile.getInt("CloudStack/pingMachineTimeout", 300);
    }

    public Integer getSshTimeout() {
        return this.configFile.getInt("CloudStack/sshMachineTimeout", 300);
    }

    public String getVmPassword() {
        return this.configFile.getString("CloudStack/virtualMachinePassword");
    }

    public String getAdminMachineArtifactPath() {
        return this.configFile.getString("Infrastructure/adminMachineArtifactPath", "/export/artifacts/current");
    }

    public Boolean abortIfConfigureOrVerifyFails() {
        return this.configFile.getBoolean("Infrastructure/abortIfConfigureOrVerifyFails", true);
    }

    public Boolean cleanFailedEnvironment() {
        return this.configFile.getBoolean("Infrastructure/cleanFailedEnvironment", true);
    }

    public String getDockerRegistryPath() {
        return this.configFile.getString("Infrastructure/dockerRegistryPath", "/opt/data/registry");
    }

    public String getDockerImagesDB2Path() {
        return this.configFile.getString("DockerImages/db2Path", "provisioning-db2");
    }

    public String getDockerImagesDB2Tag() {
        return this.configFile.getString("DockerImages/db2Tag", "latest");
    }

    public String getDockerImagesJasPath() {
        return this.configFile.getString("DockerImages/jasPath");
    }

    public String getDockerImagesJasTag() {
        return this.configFile.getString("DockerImages/jasTag");
    }

    public String getDockerImagesProvisioningPath() {
        return this.configFile.getString("DockerImages/provisioningPath");
    }

    public String getDockerImagesProvisioningTag() {
        return this.configFile.getString("DockerImages/provisioningTag");
    }

    public String getDockerImagesMQTTPath() {
        return this.configFile.getString("DockerImages/mqttPath");
    }

    public String getDockerImagesMQTTTag() {
        return this.configFile.getString("DockerImages/mqttTag");
    }

    public String getDockerImagesMQTTUIPath() {
        return this.configFile.getString("DockerImages/mqttuiPath");
    }

    public String getDockerImagesMQTTUITag() {
        return this.configFile.getString("DockerImages/mqttuiTag");
    }

    public String getDockerImagesKupaPath() {
        return this.configFile.getString("DockerImages/kupaPath", "provisioning-kupa/607");
    }

    public String getDockerImagesKupaTag() {
        return this.configFile.getString("DockerImages/kupaTag", "latest");
    }

    public String getDockerImagesOrgPath() {
        return this.configFile.getString("DockerImages/orgPath", "provisioning-org/607");
    }

    public String getDockerImagesOrgTag() {
        return this.configFile.getString("DockerImages/orgTag", "latest");
    }

    public String getDockerImageHaproxyPath() {
        return this.configFile.getString("DockerImages/haProxyPath", "provisioning-haproxy/607");
    }

    public String getDockerImageHaproxyTag() {
        return this.configFile.getString("DockerImages/haProxyTag", "latest");
    }

    public String getDockerImageStoragePath() {
        return this.configFile.getString("DockerImages/storagePath", "monitoring-storage/607");
    }

    public String getDockerImageStorageTag() {
        return this.configFile.getString("DockerImages/storageTag", "latest");
    }

    public String getDockerImageOpsDataStoreApiPath() {
        return this.configFile.getString("DockerImages/opsdatastoreapiPath", "monitoring-opsdatastoreapi/607");
    }

    public String getDockerImageOpsDataStoreApiTag() {
        return this.configFile.getString("DockerImages/opsdatastoreapiTag", "latest");
    }

    public String getDockerImageRulesPath() {
        return this.configFile.getString("DockerImages/rulesPath", "ibmjazz-rules");
    }

    public String getDockerImageRulesTag() {
        return this.configFile.getString("DockerImages/rulesTag", "latest");
    }

    public String getDockerImageHeartbeatPath() {
        return this.configFile.getString("DockerImages/heartbeatPath", "monitoring-heartbeat/607");
    }

    public String getDockerImageHeartbeatTag() {
        return this.configFile.getString("DockerImages/heartbeatTag", "latest");
    }

    public String getDockerImageOpsPath() {
        return this.configFile.getString("DockerImages/opsPath", "monitoring-ops/607");
    }

    public String getDockerImageOpsTag() {
        return this.configFile.getString("DockerImages/opsTag", "latest");
    }

    public String getDockerImageKibanaPath() {
        return this.configFile.getString("DockerImages/kibanaPath", "monitoring-kibana/607");
    }

    public String getDockerImageKibanaTag() {
        return this.configFile.getString("DockerImages/kibanaTag", "latest");
    }

    public String getDockerImageClmPath() {
        return this.configFile.getString("DockerImages/clmPath", "monitoring-clm/607");
    }

    public String getDockerImageClmTag() {
        return this.configFile.getString("DockerImages/clmTag", "latest");
    }

    public String getDockerImageDevopsPath() {
        return this.configFile.getString("DockerImages/devOpsPath", "provisioning-devops/607");
    }

    public String getDockerImageDevopsTag() {
        return this.configFile.getString("DockerImages/devOpsTag", "latest");
    }

    public String getDockerImageDocPath() {
        return this.configFile.getString("DockerImages/docPath", "monitoring-doc/607");
    }

    public String getDockerImageDocTag() {
        return this.configFile.getString("DockerImages/docTag", "latest");
    }

    public String getServicealityAppTag() {
        return this.configFile.getString("DockerImages/serviceabilityAppTag", "latest");
    }

    public String getDockerImageK8sTag() {
        return this.configFile.getString("DockerImages/k8sTag", "latest");
    }

    public String getDockerImageK8sPath() {
        return this.configFile.getString("DockerImages/k8sPath", "provisioning-k8scontroller/607");
    }

    public String getDockerImageK8sMonitoringTag() {
        return this.configFile.getString("DockerImages/k8sMonitoringTag", "latest");
    }

    public String getDockerImageK8sMonitoringPath() {
        return this.configFile.getString("DockerImages/k8sMonitoringPath", "ibmjazz-k8monitoring");
    }

    public String getMxBeanCollectorPath() {
        return this.configFile.getString("DockerImages/mxBeanCollectorPath", "ibmjazz-k8monitoring");
    }

    public String getMxBeanCollectorTag() {
        return this.configFile.getString("DockerImages/mxBeanCollectorTag", "latest");
    }

    public ConfigFile getConfigFile() {
        return this.configFile;
    }

    public String getKubernetesDNSDomainID() {
        return this.configFile.getString("Kubernetes/DNS_DOMAINID");
    }

    public String getKubernetesDNSDomain() {
        return this.configFile.getString("Kubernetes/DNS_DOMAIN");
    }

    public String getKubernetesDNSUser() {
        return this.configFile.getString("Kubernetes/DNS_USER");
    }

    public String getKubernetesProxyUrlPattern() {
        return this.configFile.getString("Kubernetes/OPS_PROXY_URL_PATTERN", "http://@IP@:22000");
    }

    public String getKubernetesProxyPassword() {
        return this.configFile.getString("Kubernetes/PROXY_PASSWORD", "ec11ipse");
    }

    public String getKubernetesProxyPort() {
        return this.configFile.getString("Kubernetes/PROXY_PORT", "8443");
    }

    public String getKubernetesStartPort() {
        return this.configFile.getString("Kubernetes/START_PORT");
    }

    public String getKubernetesKupaOnly() {
        return this.configFile.getString("Kubernetes/KUPA_ONLY");
    }

    public String getKubernetesDNSKey() {
        return this.configFile.getString("Kubernetes/DNS_KEY");
    }

    public String getElasticSearchPort() {
        return this.configFile.getString("ES/esPort", "9200");
    }

    public String getStoragePort() {
        return this.configFile.getString("Storage/storagePort", "10300");
    }

    public String getQueryPort() {
        return this.configFile.getString("Query/queryPort", "10301");
    }

    public String getMddPort() {
        return this.configFile.getString("MDD/mddPort", "10200");
    }

    public String getRulesPort() {
        return this.configFile.getString("RULES/rulesPort", "10003");
    }

    public String getDocPort() {
        return this.configFile.getString("DOC/DocPort", "9080");
    }

    public String getHeartbeatPort() {
        return this.configFile.getString("HEARTBEAT/heartbeatPort", "30110");
    }

    public String getMqttPort() {
        return this.configFile.getString("MQTT/mqttPort", "1883");
    }

    public String getMqttAdminPort() {
        return this.configFile.getString("MQTT/mqttAdminPort", "9089");
    }

    public String getMqttuiPort() {
        return this.configFile.getString("MQTTUI/mqttuiPort", "9087");
    }

    public String getKupaUser() {
        return this.configFile.getString("KUPA/kupaUser", "kupa");
    }

    public String getKupaPassWord() {
        return this.configFile.getString("KUPA/kupaPassword", "ec11ipse");
    }

    public String getOrgPort() {
        return this.configFile.getString("ORG/orgPort", "20000");
    }

    public String getOrgPassWord() {
        return this.configFile.getString("ORG/orgPassword", "ec11ipse");
    }

    public String getOpsConsolePort() {
        return this.configFile.getString("OPS/opsConsolePort", "4000");
    }

    public String getOpsConsoleDebugPort() {
        return this.configFile.getString("OPS/opsConsoleDebugPort", "9229");
    }

    public String getKibanaProtocol() {
        return this.configFile.getString("KIBANA/kibanaProtocol", "http://");
    }

    public String getKibanaPort() {
        return this.configFile.getString("KIBANA/kibanaPort", "5601");
    }

    public String getProvisioningPort() {
        return this.configFile.getString("PROVISIONING/provisioningPort", "4444");
    }

    public String getHaproxyServerPort() {
        return this.configFile.getString("PROXY/haproxyServerPort", "8443");
    }

    public String getHaproxyServerConsolePort() {
        return this.configFile.getString("PROXY/haproxyServerConsolePort", "1936");
    }

    public String getProxyServicePort() {
        return this.configFile.getString("PROXY/proxyServicePort", "22000");
    }

    public Integer getServiceLockTimeout() {
        return this.configFile.getInt("General/serviceLockTimeout", 3600);
    }

    public Integer getVMCreationTimeout() {
        return this.configFile.getInt("General/vmCreationTimeout", 7200);
    }

    public Integer getVMCreationDelay() {
        return this.configFile.getInt("General/vmCreationDelay", 15);
    }

    public Level getCookbookLoggingLevel() {
        String value = this.configFile.getString("General/cookbookLoggingLevel", "FINE");
        try {
            return Level.parse(value);
        }
        catch (Exception e) {
            this.logger.severe("Invalid General/cookbookLoggingLevel value " + value + " provided. Falling back to FINE");
            return Level.FINE;
        }
    }

    public Integer getCookbookTimeout() {
        return this.configFile.getInt("General/cookbookTimeout", 900);
    }

    public Integer getHttpRequestTimeout() {
        return this.configFile.getInt("General/httpTimeout", 30);
    }

    public boolean getNmon() {
        return this.configFile.getBoolean("General/enableNmon", false);
    }

    public String getDockerRegistryHost() {
        return this.configFile.getString("Infrastructure/dockerRegistryHost");
    }

    public String getDockerRegistryPort() {
        return this.configFile.getString("Infrastructure/dockerRegistryPort");
    }

    public String getDockerRegistryInternal() {
        return this.configFile.getString("Infrastructure/dockerRegistryInternal");
    }

    public String getDeployScriptsPath() {
        return this.configFile.getString("Infrastructure/deployScriptsPath", "/root/deploy/scripts");
    }

    public int getKupaPort() {
        return this.configFile.getInt("KUPA/kupaPort", 20000);
    }

    public String getRegistryAppRepo() {
        return this.configFile.getString("DockerImages/appRepo", "607");
    }

    public int getDMSPort() {
        return this.configFile.getInt("DMS/port", 10111);
    }

    public String getDMSProtocol() {
        return this.configFile.getString("DMS/protocol", "https://");
    }

    public String getQRadarServer() {
        return this.configFile.getString("QRadar/server");
    }

    public String getBigFixServer() {
        return this.configFile.getString("BigFix/server");
    }

    public String getBigFixCCode() {
        return this.configFile.getString("BigFix/c_code");
    }

    public String getK8sOrgServiceName() {
        return this.configFile.getString("K8sCluster/orgServiceName", "ibmjazz-organization");
    }

    public String getK8sDockerRegistryServiceName() {
        return this.configFile.getString("K8sCluster/dockerRegServiceName", "ibmjazz-dockerregistry");
    }

    public String getK8sDeploymentServiceName() {
        return this.configFile.getString("K8sCluster/deploymentServiceName", "ibmjazz-deployment");
    }

    public String getK8sOpsDataStoreServiceName() {
        return this.configFile.getString("K8sCluster/opsDataStoreServiceName", "ibmjazz-opsdatastore");
    }

    public String getK8sOpsDataStoreApiServiceName() {
        return this.configFile.getString("K8sCluster/opsDataStoreApiServiceName", "ibmjazz-opsdatastoreapi");
    }

    public String getK8sDocServiceName() {
        return this.configFile.getString("K8sCluster/docServiceName", "ibmjazz-doc");
    }

    public String getK8sMQTTServiceName() {
        return this.configFile.getString("K8sCluster/mqttServiceName", "ibmjazz-mqtt");
    }

    public String getK8SControllerUser() {
        return this.configFile.getString("K8SCONTROLLER/loginUser", "kupa");
    }

    public String getK8SControllerPassword() {
        return this.configFile.getString("K8SCONTROLLER/loginPassword", "ec11ipse");
    }

    public String getK8SControllerPort() {
        return this.configFile.getString("K8SCONTROLLER/port", "12001");
    }

    public String getK8SControllerProtocol() {
        return this.configFile.getString("K8SCONTROLLER/protocol", "http://");
    }
}

