/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.datamodel.storage.deployment.environments;

import com.ibm.juno.core.InvalidDataConversionException;
import com.ibm.juno.core.ObjectMap;
import com.ibm.juno.core.utils.StringUtils;
import com.ibm.team.serviceability.datamodel.deployment.environments.EnvironmentFactory;
import com.ibm.team.serviceability.datamodel.deployment.environments.EnvironmentModel;
import com.ibm.team.serviceability.datamodel.deployment.environments.EnvironmentUtils;
import com.ibm.team.serviceability.datamodel.exceptions.InvalidParameterException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnvironmentStorageFactory
extends EnvironmentFactory {
    private static final Logger logger = Logger.getLogger(EnvironmentStorageFactory.class.getName());

    public EnvironmentStorageFactory() {
        logger.log(Level.FINEST, "Created new environment storage factory");
    }

    public EnvironmentModel getEnvironmentModel(ObjectMap params) throws InvalidParameterException {
        logger.log(Level.FINEST, "Getting environment object from map");
        if (params == null) {
            logger.log(Level.FINEST, "Null parameters provided");
            throw new InvalidParameterException("Provided environment parameter map was invalid");
        }
        try {
            String uuid = params.getString("uuid");
            String name = params.getString("name");
            String description = params.getString("description");
            String envCode = params.getString("envCode");
            String cidr = params.getString("cidr");
            String networkId = params.getString("networkId");
            String proxyUrl = params.getString("proxyUrl");
            String kupaUrl = params.getString("kupaUrl");
            String kubeDashUrl = params.getString("kubeDashboardUrl");
            String dataCenterUuid = params.getString("dataCenterUuid");
            String envType = params.getString("envType");
            String status = params.getString("status");
            Boolean dnsRoutingEnabled = true;
            try {
                dnsRoutingEnabled = params.getBoolean("dnsRoutingEnabled", Boolean.valueOf(true));
            }
            catch (InvalidDataConversionException e) {
                logger.log(Level.WARNING, "Invalid dnsRoutingEnabled parameter provided: {0}", params.get((Object)"dnsRoutingEnabled"));
            }
            return this.getEnvironment(uuid, name, description, envCode, cidr, networkId, proxyUrl, kupaUrl, kubeDashUrl, envType, dataCenterUuid, dnsRoutingEnabled, status);
        }
        catch (InvalidDataConversionException e) {
            logger.log(Level.WARNING, "Instance parameters were not valid");
            throw new InvalidParameterException("Provided instance information was not in a valid format", e);
        }
    }

    public EnvironmentModel updateEnvironment(EnvironmentModel environment, ObjectMap update) throws InvalidParameterException {
        String envType;
        String status;
        String kubeDashUrl;
        String proxyUrl;
        String kupaUrl;
        String networkId;
        String cidr;
        String envCode;
        String description;
        logger.log(Level.FINEST, "Updating environment object");
        if (environment == null || update == null || update.size() == 0) {
            throw new InvalidParameterException("Provided instance parameter map was invalid");
        }
        String uuid = update.getString("uuid");
        if (!StringUtils.isEmpty((String)uuid)) {
            logger.log(Level.WARNING, "Unable to update the UUID for an existing environment");
            throw new InvalidParameterException("Unable to update environment UUID");
        }
        String dataCenterUuid = update.getString("dataCenterUuid");
        String currentDcUuid = environment.getDataCenterUuid();
        if (currentDcUuid != null && currentDcUuid.equals(dataCenterUuid)) {
            dataCenterUuid = null;
        }
        if (!StringUtils.isEmpty((String)dataCenterUuid)) {
            logger.log(Level.WARNING, "Unable to update the UUID for the data center in an existing environment");
            throw new InvalidParameterException("Unable to update the UUID for the data center in an existing environment");
        }
        String name = update.getString("name");
        if (EnvironmentUtils.isValidName(name)) {
            environment.setName(name);
        }
        if (EnvironmentUtils.isValidDescription(description = update.getString("description"))) {
            environment.setDescription(description);
        }
        if (EnvironmentUtils.isValidEnvCode(envCode = update.getString("envCode"))) {
            environment.setEnvCode(envCode);
        }
        if (EnvironmentUtils.isValidCidr(cidr = update.getString("cidr"))) {
            environment.setCidr(cidr);
        }
        if (EnvironmentUtils.isValidNetworkId(networkId = update.getString("networkId"))) {
            environment.setNetworkId(networkId);
        }
        if (EnvironmentUtils.isValidKupaUrl(kupaUrl = update.getString("kupaUrl"))) {
            environment.setKupaUrl(kupaUrl);
        }
        if (EnvironmentUtils.isValidProxyUrl(proxyUrl = update.getString("proxyUrl"))) {
            environment.setProxyUrl(proxyUrl);
        }
        if (EnvironmentUtils.isValidKubeDashboardUrl(kubeDashUrl = update.getString("kubeDashboardUrl"))) {
            environment.setKubeDashboardUrl(kubeDashUrl);
        }
        if (EnvironmentUtils.isValidStatus(status = update.getString("status"))) {
            environment.setStatus(status);
        }
        if (EnvironmentUtils.isValidEnvType(envType = update.getString("envType"))) {
            environment.setEnvType(envType);
        }
        try {
            Boolean dnsRoutingEnabled = update.getBoolean("dnsRoutingEnabled");
            if (dnsRoutingEnabled != null) {
                environment.setDnsRoutingEnabled(dnsRoutingEnabled);
            }
        }
        catch (InvalidDataConversionException e) {
            logger.log(Level.WARNING, "Invalid dnsRoutingEnabled parameter provided: {0}", update.get((Object)"dnsRoutingEnabled"));
        }
        return environment;
    }
}

