/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.datamodel.storage.client.monitoring;

import com.ibm.juno.client.SSLOpts;
import com.ibm.juno.core.ObjectMap;
import com.ibm.juno.core.parser.ParseException;
import com.ibm.juno.core.serializer.SerializeException;
import com.ibm.team.serviceability.datamodel.monitoring.alm.ALMInstanceMonitoringData;
import com.ibm.team.serviceability.datamodel.storage.StorageUtils;
import com.ibm.team.serviceability.datamodel.storage.client.StorageClient;
import com.ibm.team.serviceability.datamodel.storage.client.exceptions.DataModelStorageClientException;
import java.util.List;

public class MonitoringStorageClient
extends StorageClient {
    private static final String MONITORING_PATH = "monitoring";
    private static final String MONITORING_INSTANCES_PATH = "monitoringinstances";

    public MonitoringStorageClient(String storageUrl, String storageUser, String storagePw, SSLOpts sslOpts) throws DataModelStorageClientException {
        super(storageUrl, storageUser, storagePw, sslOpts);
    }

    public boolean deleteMonitoringInstance(String instanceUuid) throws DataModelStorageClientException {
        String path = this.buildPath(MONITORING_INSTANCES_PATH, instanceUuid);
        return this.delete(path);
    }

    public boolean deleteMonitoringData(String instanceUuid) throws DataModelStorageClientException {
        ObjectMap inputMap = new ObjectMap();
        inputMap.append("index", (Object)"clmmaa*");
        String query = "almInstanceUuid:" + instanceUuid;
        inputMap.append("query", (Object)query);
        String path = this.buildPath(MONITORING_PATH, "query", "delete");
        return this.update(path, inputMap);
    }

    public boolean deleteMonitoringMetricsData(String instanceUuid) throws DataModelStorageClientException {
        ObjectMap inputMap = new ObjectMap();
        inputMap.append("index", (Object)"metricbeat*");
        String query = "http.mbean_namespace.instanceId:" + instanceUuid;
        inputMap.append("query", (Object)query);
        String path = this.buildPath(MONITORING_PATH, "query", "delete");
        return this.update(path, inputMap);
    }

    public void deleteServiceMetricsData(List<String> serviceIdList) throws DataModelStorageClientException {
        ObjectMap inputMap = new ObjectMap();
        inputMap.append("index", (Object)"servicemetrics_*");
        int i = 0;
        while (i < serviceIdList.size()) {
            String query = "service:" + serviceIdList.get(i);
            inputMap.append("query", (Object)query);
            String path = this.buildPath(MONITORING_PATH, "query", "delete");
            this.update(path, inputMap);
            ++i;
        }
    }

    public boolean saveALMMonitoringInstance(ALMInstanceMonitoringData almMonitoringData) throws DataModelStorageClientException {
        try {
            ObjectMap inputMap = StorageUtils.toObjectMap(almMonitoringData);
            if (inputMap != null) {
                String path = this.buildPath(MONITORING_INSTANCES_PATH);
                return this.create(path, inputMap);
            }
        }
        catch (ParseException | SerializeException e) {
            throw new DataModelStorageClientException("Error converting ALMInstance to ObjectMap", e);
        }
        return false;
    }
}

