/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.datamodel.storage.client.deployment;

import com.ibm.juno.client.SSLOpts;
import com.ibm.juno.core.ObjectMap;
import com.ibm.juno.core.parser.ParseException;
import com.ibm.juno.core.serializer.SerializeException;
import com.ibm.team.serviceability.datamodel.deployment.datacenter.DataCenterModel;
import com.ibm.team.serviceability.datamodel.deployment.environments.EnvironmentModel;
import com.ibm.team.serviceability.datamodel.deployment.environments.IEnvironment;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.IServiceInfo;
import com.ibm.team.serviceability.datamodel.deployment.serviceinfo.ServiceInfoModel;
import com.ibm.team.serviceability.datamodel.deployment.vm.IVirtualMachine;
import com.ibm.team.serviceability.datamodel.deployment.vm.VirtualMachineModel;
import com.ibm.team.serviceability.datamodel.storage.StorageUtils;
import com.ibm.team.serviceability.datamodel.storage.client.StorageClient;
import com.ibm.team.serviceability.datamodel.storage.client.exceptions.DataModelStorageClientException;

public class DeploymentStorageClient
extends StorageClient {
    private static final String DEPLOYMENT_PATH = "deployment";
    private static final String MONITORING_PATH = "monitoring";
    private static final String DATACENTERS_PATH = "datacenters";
    private static final String ENVIRONMENTS_PATH = "environments";
    private static final String VIRTUALMACHINES_PATH = "virtualmachines";
    private static final String SERVICES_PATH = "services";

    public DeploymentStorageClient(String storageUrl, String storageUser, String storagePw, SSLOpts sslOpts) throws DataModelStorageClientException {
        super(storageUrl, storageUser, storagePw, sslOpts);
    }

    public boolean saveDataCenterModel(DataCenterModel dcModel) throws DataModelStorageClientException {
        try {
            ObjectMap dcMap = StorageUtils.toObjectMap(dcModel);
            if (dcMap != null) {
                String path = this.buildPath(DEPLOYMENT_PATH, DATACENTERS_PATH);
                return this.create(path, dcMap);
            }
        }
        catch (ParseException | SerializeException e) {
            throw new DataModelStorageClientException("Error converting DataCenterModel to ObjectMap", e);
        }
        return false;
    }

    public boolean saveServiceInfoModel(ServiceInfoModel siModel) throws DataModelStorageClientException {
        try {
            ObjectMap siMap = StorageUtils.toObjectMap(siModel);
            if (siMap != null) {
                String path = this.buildPath(DEPLOYMENT_PATH, SERVICES_PATH);
                return this.create(path, siMap);
            }
        }
        catch (ParseException | SerializeException e) {
            throw new DataModelStorageClientException("Error converting ServiceInfoModel to ObjectMap", e);
        }
        return false;
    }

    public boolean updateDataCenterModel(DataCenterModel dcModel) throws DataModelStorageClientException {
        try {
            ObjectMap dcMap = StorageUtils.toObjectMap(dcModel);
            if (dcMap != null) {
                String path = this.buildPath(DEPLOYMENT_PATH, DATACENTERS_PATH, "update");
                return this.update(path, dcMap);
            }
        }
        catch (ParseException | SerializeException e) {
            throw new DataModelStorageClientException("Error converting DataCenterModel to ObjectMap", e);
        }
        return false;
    }

    public boolean saveEnvironmentModel(EnvironmentModel envModel) throws DataModelStorageClientException {
        try {
            ObjectMap dcMap = StorageUtils.toObjectMap(envModel);
            if (dcMap != null) {
                String path = this.buildPath(DEPLOYMENT_PATH, ENVIRONMENTS_PATH);
                return this.create(path, dcMap);
            }
        }
        catch (ParseException | SerializeException e) {
            throw new DataModelStorageClientException("Error converting EnvironmentModel to ObjectMap", e);
        }
        return false;
    }

    public boolean deleteEnvironmentModel(EnvironmentModel envModel) throws DataModelStorageClientException {
        try {
            ObjectMap dcMap = StorageUtils.toObjectMap(envModel);
            if (dcMap != null) {
                String path = this.buildPath(DEPLOYMENT_PATH, ENVIRONMENTS_PATH, envModel.getUuid());
                return this.delete(path);
            }
        }
        catch (ParseException | SerializeException e) {
            throw new DataModelStorageClientException("Error converting EnvironmentModel to ObjectMap", e);
        }
        return false;
    }

    public boolean deleteServiceInfoModel(ServiceInfoModel siModel) throws DataModelStorageClientException {
        try {
            ObjectMap dcMap = StorageUtils.toObjectMap(siModel);
            if (dcMap != null) {
                String path = this.buildPath(DEPLOYMENT_PATH, SERVICES_PATH, siModel.getUuid());
                return this.delete(path);
            }
        }
        catch (ParseException | SerializeException e) {
            throw new DataModelStorageClientException("Error converting ServiceInfoModel to ObjectMap", e);
        }
        return false;
    }

    public boolean deleteVirtualMachineModel(VirtualMachineModel vmModel) throws DataModelStorageClientException {
        try {
            ObjectMap dcMap = StorageUtils.toObjectMap(vmModel);
            if (dcMap != null) {
                String path = this.buildPath(DEPLOYMENT_PATH, VIRTUALMACHINES_PATH, vmModel.getUuid());
                return this.delete(path);
            }
        }
        catch (ParseException | SerializeException e) {
            throw new DataModelStorageClientException("Error converting VirtualMachineModel to ObjectMap", e);
        }
        return false;
    }

    public boolean deleteVirtualMachineModel(String vmUuid) throws DataModelStorageClientException {
        String path = this.buildPath(DEPLOYMENT_PATH, VIRTUALMACHINES_PATH, vmUuid);
        return this.delete(path);
    }

    public boolean deleteDataCenterModel(DataCenterModel dcModel) throws DataModelStorageClientException {
        try {
            ObjectMap dcMap = StorageUtils.toObjectMap(dcModel);
            if (dcMap != null) {
                String path = this.buildPath(DEPLOYMENT_PATH, DATACENTERS_PATH, dcModel.getUuid());
                return this.delete(path);
            }
        }
        catch (ParseException | SerializeException e) {
            throw new DataModelStorageClientException("Error converting DataCenterModel to ObjectMap", e);
        }
        return false;
    }

    public boolean deleteEnvironmentHeartbeat(IEnvironment envModel) throws DataModelStorageClientException {
        if (envModel != null) {
            String path = this.buildPath(MONITORING_PATH, "query", "delete");
            ObjectMap query = new ObjectMap();
            query.put((Object)"index", (Object)"heartbeat_*");
            query.put((Object)"type", (Object)"Heartbeat");
            query.put((Object)"query", (Object)("environment:" + envModel.getUuid()));
            return this.update(path, query);
        }
        return false;
    }

    public boolean deleteHeartbeatByServiceInfo(IServiceInfo siModel) throws DataModelStorageClientException {
        if (siModel != null) {
            String path = this.buildPath(MONITORING_PATH, "query", "delete");
            ObjectMap query = new ObjectMap();
            query.put((Object)"index", (Object)"heartbeat_*");
            query.put((Object)"type", (Object)"Heartbeat");
            query.put((Object)"query", (Object)("service:" + siModel.getUuid()));
            return this.update(path, query);
        }
        return false;
    }

    public boolean deleteAppbeatByUUID(String uuid) throws DataModelStorageClientException {
        if (uuid != null) {
            String path = this.buildPath(MONITORING_PATH, "query", "delete");
            ObjectMap query = new ObjectMap();
            query.put((Object)"index", (Object)"heartbeat_*");
            query.put((Object)"type", (Object)"Appbeat");
            query.put((Object)"query", (Object)("service:" + uuid));
            return this.update(path, query);
        }
        return false;
    }

    public boolean updateEnvironmentModel(IEnvironment envModel) throws DataModelStorageClientException {
        try {
            ObjectMap dcMap = StorageUtils.toObjectMap(envModel);
            if (dcMap != null) {
                String path = this.buildPath(DEPLOYMENT_PATH, ENVIRONMENTS_PATH, "update", envModel.getUuid());
                return this.update(path, dcMap);
            }
        }
        catch (ParseException | SerializeException e) {
            throw new DataModelStorageClientException("Error converting EnvironmentModel to ObjectMap", e);
        }
        return false;
    }

    public boolean saveVirtualMachineModel(VirtualMachineModel vmModel) throws DataModelStorageClientException {
        try {
            ObjectMap dcMap = StorageUtils.toObjectMap(vmModel);
            if (dcMap != null) {
                String path = this.buildPath(DEPLOYMENT_PATH, VIRTUALMACHINES_PATH);
                return this.create(path, dcMap);
            }
        }
        catch (ParseException | SerializeException e) {
            throw new DataModelStorageClientException("Error converting VirtualMachineModel to ObjectMap", e);
        }
        return false;
    }

    public boolean updateVirtualMachineModel(IVirtualMachine vmModel) throws DataModelStorageClientException {
        try {
            ObjectMap dcMap = StorageUtils.toObjectMap(vmModel);
            if (dcMap != null) {
                String path = this.buildPath(DEPLOYMENT_PATH, VIRTUALMACHINES_PATH, "update", vmModel.getUuid());
                return this.update(path, dcMap);
            }
        }
        catch (ParseException | SerializeException e) {
            throw new DataModelStorageClientException("Error converting VirtualMachineModel to ObjectMap", e);
        }
        return false;
    }
}

