/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.datamodel.rules;

import com.ibm.juno.core.InvalidDataConversionException;
import com.ibm.team.serviceability.datamodel.Comment;
import com.ibm.team.serviceability.datamodel.exceptions.InvalidParameterException;
import com.ibm.team.serviceability.datamodel.rules.EventModel;
import com.ibm.team.serviceability.datamodel.rules.EventUtils;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventFactory {
    private static final Logger logger = Logger.getLogger(EventFactory.class.getName());

    public EventFactory() {
        logger.log(Level.FINEST, "Created new ALM Instance Monitoring factory");
    }

    public EventModel getEventModel(String eventId, String description, EventModel.EventStatus status, String timestamp, String ruleid, EventModel.EventType eventType, List<Comment> comments, Map<String, String> contextInfo, String endTime, String tier, String currentAttributeValue, String level, String assignedUser) throws InvalidParameterException {
        try {
            if (EventUtils.isValidEventId(eventId) && EventUtils.isValidDescription(description) && EventUtils.isValidStatus(status) && EventUtils.isValidRuleId(ruleid) && EventUtils.isValidEventType(eventType) && EventUtils.isValidComment(comments) && EventUtils.isValidTier(tier) && EventUtils.isValidLevel(level) && EventUtils.isValidAssignedUser(assignedUser)) {
                return new EventModel(eventId, description, status, timestamp, ruleid, eventType, comments, contextInfo, endTime, tier, currentAttributeValue, level, assignedUser);
            }
            throw new InvalidParameterException("Provided instance information was not in a valid format");
        }
        catch (InvalidDataConversionException e) {
            throw new InvalidParameterException("Provided instance information was not in a valid format", e);
        }
    }
}

