/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.datamodel.provisioning.organizations;

import com.ibm.juno.core.InvalidDataConversionException;
import com.ibm.juno.core.utils.StringUtils;
import com.ibm.team.serviceability.datamodel.Comment;
import com.ibm.team.serviceability.datamodel.DNSAlias;
import com.ibm.team.serviceability.datamodel.exceptions.InvalidParameterException;
import com.ibm.team.serviceability.datamodel.provisioning.organizations.OrganizationModel;
import com.ibm.team.serviceability.datamodel.provisioning.organizations.OrganizationUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OrganizationFactory {
    private static final Logger logger = Logger.getLogger(OrganizationFactory.class.getName());

    public OrganizationFactory() {
        logger.log(Level.FINEST, "Created new organization factory");
    }

    public OrganizationModel getOrganization(String uuid, String name, String email, String created, String lastModified, String phoneNumber, String status, List<Comment> comments, List<DNSAlias> aliases, List<DNSAlias> customAliases, boolean onlyOneHost, int dnsAliasesCount) throws InvalidParameterException {
        logger.log(Level.FINEST, "Getting organization object");
        try {
            if (StringUtils.isEmpty((String)created)) {
                created = Long.toString(System.currentTimeMillis());
            }
            if (StringUtils.isEmpty((String)lastModified)) {
                lastModified = Long.toString(System.currentTimeMillis());
            }
            if (OrganizationUtils.isValidUuid(uuid) && OrganizationUtils.isValidName(name) && OrganizationUtils.isValidEmail(email) && OrganizationUtils.isValidAliasCount(dnsAliasesCount)) {
                return new OrganizationModel(uuid, name, email, created, lastModified, phoneNumber, status, comments, aliases, customAliases, onlyOneHost, dnsAliasesCount);
            }
            logger.log(Level.WARNING, "Provided organization information was not in a valid format");
            throw new InvalidParameterException("Provided organization information was not in a valid format");
        }
        catch (InvalidDataConversionException e) {
            logger.log(Level.WARNING, "Provided organization information was not in a valid format");
            throw new InvalidParameterException("Provided organization information was not in a valid format", e);
        }
    }

    public OrganizationModel getOrganization(String uuid, String name, String prefix, String email, String created, String lastModified, String phoneNumber, String status, List<Comment> comments, List<DNSAlias> aliases, List<DNSAlias> customAliases, boolean onlyOneHost, int dnsAliasesCount) throws InvalidParameterException {
        logger.log(Level.FINEST, "Getting organization object");
        try {
            if (StringUtils.isEmpty((String)created)) {
                created = Long.toString(System.currentTimeMillis());
            }
            if (StringUtils.isEmpty((String)lastModified)) {
                lastModified = Long.toString(System.currentTimeMillis());
            }
            if (OrganizationUtils.isValidUuid(uuid) && OrganizationUtils.isValidName(name) && OrganizationUtils.isValidEmail(email) && OrganizationUtils.isValidAliasCount(dnsAliasesCount)) {
                return new OrganizationModel(uuid, name, prefix, email, created, lastModified, phoneNumber, status, comments, aliases, customAliases, onlyOneHost, dnsAliasesCount);
            }
            logger.log(Level.WARNING, "Provided organization information was not in a valid format");
            throw new InvalidParameterException("Provided organization information was not in a valid format");
        }
        catch (InvalidDataConversionException e) {
            logger.log(Level.WARNING, "Provided organization information was not in a valid format");
            throw new InvalidParameterException("Provided organization information was not in a valid format", e);
        }
    }
}

