/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.datamodel.deployment.vm;

import com.ibm.juno.core.ObjectMap;
import com.ibm.juno.core.utils.StringUtils;
import com.ibm.team.serviceability.datamodel.AbstractUtils;
import com.ibm.team.serviceability.datamodel.deployment.environments.EnvironmentUtils;
import com.ibm.team.serviceability.datamodel.deployment.vm.VirtualMachineType;

public class VirtualMachineUtils
extends AbstractUtils {
    private static final String VM_UUID_PREFIX = "vm";
    private static final int VM_UUID_SUFFIX_LENGTH = 32;
    private static final int VM_UUID_LENGTH = "vm".length() + 32;
    private static final String VM_UUID_PATTERN = "^vm[a-z0-9]+$";

    public static boolean isValidUuid(String uuid) {
        return !StringUtils.isEmpty((String)uuid) && uuid.length() == VM_UUID_LENGTH && uuid.matches(VM_UUID_PATTERN);
    }

    public static boolean isValidName(String name) {
        return !StringUtils.isEmpty((String)name);
    }

    public static boolean isValidType(VirtualMachineType type) {
        return type != null;
    }

    public static boolean isValidEnvironmentUuid(String environmentUuid) {
        return EnvironmentUtils.isValidUuid(environmentUuid);
    }

    public static boolean isValidNetworkId(String networkId) {
        return !StringUtils.isEmpty((String)networkId);
    }

    public static String generateUUID() {
        return VM_UUID_PREFIX + StringUtils.generateUUID((int)32);
    }

    public static boolean isValidIp(String ip) {
        return !StringUtils.isEmpty((String)ip);
    }

    public static boolean isValidPublicIp(String publicIp) {
        return publicIp != null;
    }

    public static boolean isValidUser(String user) {
        return !StringUtils.isEmpty((String)user);
    }

    public static boolean isValidPassword(String password) {
        return !StringUtils.isEmpty((String)password);
    }

    public static boolean isValidExists(Boolean exists) {
        return exists != null;
    }

    public static boolean isValidIsCloudStack(Boolean isCloudStack) {
        return isCloudStack != null;
    }

    public static boolean isValidHostname(String hostname) {
        return !StringUtils.isEmpty((String)hostname);
    }

    public static boolean isValidNodeName(String nodeName) {
        return !StringUtils.isEmpty((String)nodeName);
    }

    public static boolean isValidMachineId(String machineId) {
        return !StringUtils.isEmpty((String)machineId);
    }

    public static boolean isValidDiskspace(Integer diskspace) {
        return diskspace != null;
    }

    public static boolean isValidCpuCount(Integer cpuCount) {
        return cpuCount != null;
    }

    public static boolean isValidRamSize(Integer ramSize) {
        return ramSize != null;
    }

    public static boolean isValidStatus(String status) {
        return !StringUtils.isEmpty((String)status);
    }

    public static boolean isValidExtendedParameters(ObjectMap extendedParameters) {
        return extendedParameters != null;
    }
}

