/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.datamodel.deployment.environments;

import com.ibm.juno.core.utils.StringUtils;
import com.ibm.team.serviceability.datamodel.DataObject;
import com.ibm.team.serviceability.datamodel.DataType;
import com.ibm.team.serviceability.datamodel.deployment.environments.IEnvironment;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnvironmentModel
extends DataObject
implements IEnvironment,
Comparable<EnvironmentModel> {
    private static final Logger logger = Logger.getLogger(EnvironmentModel.class.getName());
    private String name;
    private String description;
    private String envCode = "";
    private String cidr = "";
    private String networkId = "";
    private String kupaUrl = "";
    private String kubeDashboardUrl = "";
    private String proxyUrl = "";
    private String dataCenterUuid = "";
    private String envType = null;
    private String status = "";
    private boolean dnsRoutingEnabled;

    public EnvironmentModel(String uuid, String name, String description, String envCode, String cidr, String networkId, String proxyUrl, String kupaUrl, String kubeDashUrl, String envType, String dataCenterUuid, boolean dnsRoutingEnabled, String status) {
        super(uuid, DataType.Environment);
        this.name = name;
        this.description = description;
        this.envCode = envCode;
        this.cidr = cidr;
        this.networkId = networkId;
        this.envType = envType;
        this.proxyUrl = proxyUrl;
        this.kupaUrl = kupaUrl;
        this.kubeDashboardUrl = kubeDashUrl;
        this.dataCenterUuid = dataCenterUuid;
        this.dnsRoutingEnabled = dnsRoutingEnabled;
        this.status = status;
        logger.log(Level.FINEST, "Created new environment with uuid " + uuid + " and name " + name);
    }

    public EnvironmentModel(IEnvironment env) {
        super(env.getUuid(), DataType.Environment);
        this.name = env.getName();
        this.description = env.getDescription();
        this.envCode = env.getEnvCode();
        this.cidr = env.getCidr();
        this.networkId = env.getNetworkId();
        this.envType = env.getEnvType();
        this.kupaUrl = env.getKupaUrl();
        this.kubeDashboardUrl = env.getKubeDashboardUrl();
        this.proxyUrl = env.getProxyUrl();
        this.dataCenterUuid = env.getDataCenterUuid();
        this.dnsRoutingEnabled = env.isDnsRoutingEnabled();
        this.status = env.getStatus();
    }

    @Override
    public String getName() {
        logger.log(Level.FINEST, "Getting name for environment");
        return this.name;
    }

    @Override
    public String getDescription() {
        logger.log(Level.FINEST, "Getting description for environment");
        return this.description;
    }

    @Override
    public String getEnvCode() {
        logger.log(Level.FINEST, "Getting envCode for environment");
        return this.envCode;
    }

    @Override
    public String getCidr() {
        logger.log(Level.FINEST, "Getting cidr for environment");
        return this.cidr;
    }

    @Override
    public String getNetworkId() {
        logger.log(Level.FINEST, "Getting networkId for environment");
        return this.networkId;
    }

    @Override
    public String getProxyUrl() {
        logger.log(Level.FINEST, "Getting proxyUrl for environment");
        return this.proxyUrl;
    }

    @Override
    public boolean setProxyUrl(String url) {
        logger.log(Level.FINEST, "Setting proxyUrl for environment: " + url);
        if (!StringUtils.isEmpty((String)url)) {
            this.proxyUrl = url;
            logger.log(Level.FINEST, "environment proxyUrl changed successfully");
            return true;
        }
        logger.log(Level.FINEST, "environment proxyUrl changed unsuccessfully");
        return false;
    }

    @Override
    public String getKupaUrl() {
        logger.log(Level.FINEST, "Getting kupaURL for environment");
        return this.kupaUrl;
    }

    @Override
    public String getKubeDashboardUrl() {
        return this.kubeDashboardUrl;
    }

    @Override
    public boolean setKubeDashboardUrl(String url) {
        logger.log(Level.FINEST, "Setting kubeDashboardUrl for environment: " + url);
        if (!StringUtils.isEmpty((String)url)) {
            this.kubeDashboardUrl = url;
            logger.log(Level.FINEST, "environment kubeDashboardUrl changed successfully");
            return true;
        }
        logger.log(Level.FINEST, "environment kubeDashboardUrl changed unsuccessfully");
        return false;
    }

    @Override
    public String getEnvType() {
        logger.log(Level.FINEST, "Getting type for environment");
        return this.envType;
    }

    @Override
    public String getDataCenterUuid() {
        return this.dataCenterUuid;
    }

    @Override
    public boolean isDnsRoutingEnabled() {
        return this.dnsRoutingEnabled;
    }

    public boolean setName(String name) {
        logger.log(Level.FINEST, "Setting name for environment: " + name);
        if (!StringUtils.isEmpty((String)name)) {
            this.name = name;
            logger.log(Level.FINEST, "environment name changed successfully");
            return true;
        }
        logger.log(Level.FINEST, "environment name changed unsuccessfully");
        return false;
    }

    public boolean setDescription(String description) {
        logger.log(Level.FINEST, "Setting name for description: " + description);
        if (!StringUtils.isEmpty((String)description)) {
            this.description = description;
            logger.log(Level.FINEST, "environment description changed successfully");
            return true;
        }
        logger.log(Level.FINEST, "environment description changed unsuccessfully");
        return false;
    }

    public boolean setEnvCode(String envCode) {
        logger.log(Level.FINEST, "Setting envCode for envCode: " + envCode);
        if (!StringUtils.isEmpty((String)envCode)) {
            this.envCode = envCode;
            logger.log(Level.FINEST, "environment envCode changed successfully");
            return true;
        }
        logger.log(Level.FINEST, "environment envCode changed unsuccessfully");
        return false;
    }

    public boolean setCidr(String cidr) {
        logger.log(Level.FINEST, "Setting cidr for environment: " + cidr);
        if (!StringUtils.isEmpty((String)cidr)) {
            this.cidr = cidr;
            logger.log(Level.FINEST, "environment cidr changed successfully");
            return true;
        }
        logger.log(Level.FINEST, "environment cidr changed unsuccessfully");
        return false;
    }

    public boolean setNetworkId(String networkId) {
        logger.log(Level.FINEST, "Setting networkId for environment: " + networkId);
        if (!StringUtils.isEmpty((String)networkId)) {
            this.networkId = networkId;
            logger.log(Level.FINEST, "environment networkId changed successfully");
            return true;
        }
        logger.log(Level.FINEST, "environment networkId changed unsuccessfully");
        return false;
    }

    @Override
    public boolean setKupaUrl(String url) {
        logger.log(Level.FINEST, "Setting kupaURL for environment: " + url);
        if (!StringUtils.isEmpty((String)url)) {
            this.kupaUrl = url;
            logger.log(Level.FINEST, "environment kupaURL changed successfully");
            return true;
        }
        logger.log(Level.FINEST, "environment kupaURL changed unsuccessfully");
        return false;
    }

    public boolean setEnvType(String envType) {
        logger.log(Level.FINEST, "Setting type for environment: " + envType);
        if (envType != null) {
            this.envType = envType;
            logger.log(Level.FINEST, "environment type changed successfully");
            return true;
        }
        logger.log(Level.FINEST, "environment type changed unsuccessfully");
        return false;
    }

    public void setDnsRoutingEnabled(boolean dnsRoutingEnabled) {
        logger.log(Level.FINEST, "Setting DNS routing enablement for environment: " + dnsRoutingEnabled);
        this.dnsRoutingEnabled = dnsRoutingEnabled;
    }

    @Override
    public String getStatus() {
        logger.log(Level.FINEST, "Getting status for environment");
        return this.status;
    }

    public boolean setStatus(String status) {
        logger.log(Level.FINEST, "Setting status for environment: " + status);
        if (status != null) {
            this.status = status;
            logger.log(Level.FINEST, "Environment status changed successfully");
            return true;
        }
        logger.log(Level.FINEST, "Environment status changed unsuccessfully");
        return false;
    }

    @Override
    public int compareTo(EnvironmentModel env) {
        return this.getUuid().compareTo(env.getUuid());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Environment (");
        sb.append(this.name);
        sb.append(",");
        sb.append(this.envCode);
        sb.append(",");
        sb.append(this.description);
        if (this.cidr != null) {
            sb.append(",");
            sb.append(this.cidr);
        }
        sb.append(")");
        sb.append("\n");
        return sb.toString();
    }
}

