/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.datamodel.deployment.datacenter;

import com.ibm.juno.core.utils.StringUtils;
import com.ibm.team.serviceability.datamodel.AbstractUtils;

public class DataCenterUtils
extends AbstractUtils {
    private static final String DC_UUID_PREFIX = "dc";
    private static final int DC_UUID_SUFFIX_LENGTH = 5;
    private static final int DC_UUID_LENGTH = "dc".length() + 5;
    private static final String DC_UUID_PATTERN = "^dc[a-z0-9]+$";
    private static final int SHORTNAME_LENGTH = 3;

    public static boolean isValidUuid(String uuid) {
        return !StringUtils.isEmpty((String)uuid) && uuid.length() == DC_UUID_LENGTH && uuid.matches(DC_UUID_PATTERN);
    }

    public static boolean isValidShortName(String shortName) {
        return !StringUtils.isEmpty((String)shortName) && shortName.length() == 3;
    }

    public static boolean isValidName(String name) {
        return !StringUtils.isEmpty((String)name);
    }

    public static boolean isValidDescription(String description) {
        return !StringUtils.isEmpty((String)description);
    }

    public static boolean isValidVpcName(String vpcName) {
        return !StringUtils.isEmpty((String)vpcName);
    }

    public static boolean isValidCidr(String cidr) {
        return !StringUtils.isEmpty((String)cidr);
    }

    public static boolean isValidDomainName(String domainName) {
        return !StringUtils.isEmpty((String)domainName);
    }

    public static boolean isValidNetworkId(String networkId) {
        return !StringUtils.isEmpty((String)networkId);
    }

    public static boolean isValidVpcId(String vpcId) {
        return !StringUtils.isEmpty((String)vpcId);
    }

    public static String generateUUID() {
        return DC_UUID_PREFIX + StringUtils.generateUUID((int)5);
    }
}

