/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.cloudstack.client.test;

import com.ibm.juno.core.ObjectList;
import com.ibm.juno.core.ObjectMap;
import com.ibm.team.serviceability.cloudstack.client.CloudStackCommandManager;
import com.ibm.team.serviceability.cloudstack.client.command.CloudStackCommandException;
import com.ibm.team.serviceability.cloudstack.client.test.TestConstants;
import java.util.ArrayList;

public class CloudStackDeleteTestVPC {
    public static final String ALL = "ALL";

    public static void usage() {
        System.out.println("Usage: ");
        System.out.println("CloudStackDeleteVPC cloudstackurl apikey secretkey vpcName");
        System.out.println("e.g. CloudStackDeleteVPC http://1.2.3.4:8080/client/api plgWJfZK4gyS3mOMTVm VDaACYb0LV9eNjTetIOE \"ALM Network for t10\"");
        System.out.println("e.g. CloudStackDeleteVPC http://1.2.3.4:8080/client/api plgWJfZK4gyS3mOMTVm VDaACYb0LV9eNjTetIOE ALL");
    }

    private void run(String apiSereverURL, String apiKey, String secretKey, String vpcName) {
        CloudStackCommandManager.INSTANCE.initialize(apiSereverURL, apiKey, secretKey);
        try {
            ArrayList<String> vpcList = new ArrayList<String>();
            if (ALL.equals(vpcName)) {
                ObjectList list = CloudStackCommandManager.INSTANCE.findAllVPCs();
                for (Object obj : list) {
                    ObjectMap object = (ObjectMap)obj;
                    String name = object.getString("name");
                    if (!name.startsWith(TestConstants.VPC_NAME_PREFIX)) continue;
                    vpcList.add(name);
                }
            } else {
                vpcList.add(vpcName);
            }
            for (String name : vpcList) {
                System.out.println("VPC : " + name);
                this.deleteEntireVPCNetwork(name);
            }
        }
        catch (CloudStackCommandException e) {
            System.out.println("Error during call to CloudStack: " + e.getMessage());
        }
    }

    private void deleteEntireVPCNetwork(String vpcName) throws CloudStackCommandException {
        ObjectMap vpc = null;
        String vpcId = null;
        System.out.println("> Locating VPC " + vpcName);
        ObjectList vpcObjectList = CloudStackCommandManager.INSTANCE.findVPCs(null, vpcName);
        if (vpcObjectList.size() > 0) {
            System.out.println("    > VPC with name " + vpcName + " exists");
            vpc = (ObjectMap)vpcObjectList.get(0);
        }
        if (vpc == null) {
            System.out.println("    > Unable to locate VPC with name " + vpcName);
            System.out.println("    > Exiting delete VPC.");
            return;
        }
        vpcId = vpc.getString("id");
        ObjectList NetworkObjectList = CloudStackCommandManager.INSTANCE.findNetworks(null, vpcId);
        if (NetworkObjectList.size() > 0) {
            System.out.println("    > " + NetworkObjectList.size() + " network found.");
            for (Object networkObject : NetworkObjectList) {
                ObjectMap currentNetwork = (ObjectMap)networkObject;
                String networkid = currentNetwork.getString("id");
                String networkName = currentNetwork.getString("name");
                System.out.println("    > Deleting network " + networkName);
                boolean deleteSuccess = CloudStackCommandManager.INSTANCE.deleteNetworkWithMachines(networkid);
                if (!deleteSuccess) {
                    System.err.println("Failed  to delete Network " + networkName);
                    continue;
                }
                System.out.println("        > Successfully deleted network");
            }
        }
        System.out.println("    > Deleting VPC " + vpcName);
        boolean deleteSuccess = CloudStackCommandManager.INSTANCE.deleteVPC(vpcId);
        if (!deleteSuccess) {
            System.err.println("Failed  to delete VPC " + vpcName);
        } else {
            System.out.println("        > Successfully deleted VPC");
        }
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            CloudStackDeleteTestVPC.usage();
            System.exit(1);
        }
        String url = args[0];
        String apikey = args[1];
        String secretkey = args[2];
        String vpcName = args[3];
        CloudStackDeleteTestVPC obj = new CloudStackDeleteTestVPC();
        obj.run(url, apikey, secretkey, vpcName);
    }
}

