/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.serviceability.cloudstack.client.test;

import com.ibm.juno.core.ObjectList;
import com.ibm.juno.core.ObjectMap;
import com.ibm.team.serviceability.cloudstack.client.CloudStackCommandManager;
import com.ibm.team.serviceability.cloudstack.client.CloudStackUtils;
import com.ibm.team.serviceability.cloudstack.client.command.CloudStackCommandException;

public class CloudStackAttachVolumeTest {
    private static String ROOT_VOLUME_PRE_TEXT = "ROOT-";
    private static String VOLUME_KEY_GPFS = "-gpfs-";
    private static String VOLUME_KEY_ROOT = "-root-";

    public static void usage() {
        System.out.println("Usage: ");
        System.out.println("CloudStackClientSample cloudstackurl apikey secretkey");
        System.out.println("e.g. CloudStackClientSample http://1.2.3.4:8080/client/api plgWJfZK4gyS3mOMTVmjUVg-X-jlWlnfaU VDaACYb0LV9eNjTetIOElcVQkvJ");
    }

    private void printObjectList(ObjectList list) {
        for (Object obj : list) {
            ObjectMap zone = (ObjectMap)obj;
            System.out.println(zone);
        }
    }

    private void listVolume() throws CloudStackCommandException {
        System.out.println("=== List Volume");
        ObjectList returnList = CloudStackCommandManager.INSTANCE.findVolumesByVmId("89012664-d5f1-4abf-ad48-faf3df2e9946");
        System.out.println("==== Volumes ==== : " + returnList.size());
        this.printObjectList(returnList);
        System.out.println("");
    }

    private void volumeTest() throws CloudStackCommandException {
        String machineId = "52ddcc2f-2664-4334-b3f6-b5feb59ff74c";
        String disk1 = "fdf33932-1337-4004-9dd5-980e52b87257";
        String disk2 = "f465e5b7-1a28-47ee-81c8-d19cc3bd07d8";
        String disk3 = "750dee31-a669-4440-a859-ddebbd70ce8a";
        System.out.println(CloudStackUtils.generateKVMLinuxDiskid(disk1));
        System.out.println("volumeTest begin");
        ObjectMap map = null;
        map = CloudStackUtils.createAndAttachVolumeToVirtualMachineForGPFS(machineId, 3);
        System.out.println(map);
        map = CloudStackUtils.createAndAttachVolumeToVirtualMachine(machineId, 4);
        System.out.println(map);
        System.out.println("volumeTest done");
    }

    private static String getNextVolumeName(String machineId, boolean forGPFS) throws CloudStackCommandException {
        ObjectList volumes = CloudStackCommandManager.INSTANCE.findVolumesByVmId(machineId);
        String machineName = null;
        String rootVolumeNumber = null;
        for (Object object : volumes) {
            String volumeName;
            if (!(object instanceof ObjectMap)) continue;
            if (machineName == null) {
                machineName = ((ObjectMap)object).getString("vmname");
            }
            if (!(volumeName = ((ObjectMap)object).getString("name")).startsWith(ROOT_VOLUME_PRE_TEXT)) continue;
            rootVolumeNumber = volumeName.substring(ROOT_VOLUME_PRE_TEXT.length());
        }
        int newVolumeNumber = volumes.size() + 1;
        String name = null;
        name = forGPFS ? String.valueOf(machineName) + "-" + rootVolumeNumber + VOLUME_KEY_GPFS + newVolumeNumber : String.valueOf(machineName) + "-" + rootVolumeNumber + VOLUME_KEY_ROOT + newVolumeNumber;
        if (machineName != null) {
            String pattern = null;
            pattern = forGPFS ? String.valueOf(machineName) + "-" + rootVolumeNumber + VOLUME_KEY_GPFS : String.valueOf(machineName) + "-" + rootVolumeNumber + VOLUME_KEY_ROOT;
            int lastVolumeNumber = 0;
            for (Object object : volumes) {
                String volumeName;
                System.out.println(object);
                if (!(object instanceof ObjectMap) || !(volumeName = ((ObjectMap)object).getString("name")).startsWith(pattern)) continue;
                try {
                    int num = Integer.parseInt(volumeName.substring(pattern.length()));
                    if (lastVolumeNumber >= num) continue;
                    lastVolumeNumber = num;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            name = String.valueOf(pattern) + (lastVolumeNumber + 1);
        }
        return name;
    }

    private void run(String apiSereverURL, String apiKey, String secretKey) {
        CloudStackCommandManager.INSTANCE.initialize(apiSereverURL, apiKey, secretKey);
        CloudStackCommandManager.INSTANCE.setDebug(true);
        try {
            this.volumeTest();
        }
        catch (CloudStackCommandException e) {
            System.out.println("Error during call to CloudStack: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            CloudStackAttachVolumeTest.usage();
            System.exit(1);
        }
        String url = args[0];
        String apikey = args[1];
        String secretkey = args[2];
        CloudStackAttachVolumeTest obj = new CloudStackAttachVolumeTest();
        obj.run(url, apikey, secretkey);
    }
}

